/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.helpers.v249;

import com.jme3.renderer.Camera;
import com.jme3.scene.plugins.blender.data.Structure;
import com.jme3.scene.plugins.blender.exception.BlenderFileException;
import com.jme3.scene.plugins.blender.utils.AbstractBlenderHelper;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CameraHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(CameraHelper.class.getName());
    protected static final int DEFAULT_CAM_WIDTH = 100;
    protected static final int DEFAULT_CAM_HEIGHT = 100;

    public CameraHelper(String blenderVersion) {
        super(blenderVersion);
    }

    public Camera toCamera(Structure structure) throws BlenderFileException {
        Camera result = new Camera(100, 100);
        int type = ((Number)structure.getFieldValue("type")).intValue();
        if (type != 0 && type != 1) {
            LOGGER.log(Level.WARNING, "Unknown camera type: " + type + ". Perspective camera is being used!");
            type = 0;
        }
        result.setParallelProjection(type == 1);
        float angle = ((Number)structure.getFieldValue("angle")).floatValue();
        float aspect = 0.0f;
        float clipsta = ((Number)structure.getFieldValue("clipsta")).floatValue();
        float clipend = ((Number)structure.getFieldValue("clipend")).floatValue();
        aspect = type == 0 ? ((Number)structure.getFieldValue("lens")).floatValue() : ((Number)structure.getFieldValue("ortho_scale")).floatValue();
        result.setFrustumPerspective(angle, aspect, clipsta, clipend);
        return result;
    }
}

