/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.helpers.v249;

import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.plugins.blender.data.Structure;
import com.jme3.scene.plugins.blender.exception.BlenderFileException;
import com.jme3.scene.plugins.blender.helpers.v249.TextureHelper;
import com.jme3.scene.plugins.blender.utils.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.utils.DataRepository;
import com.jme3.scene.plugins.blender.utils.DynamicArray;
import com.jme3.scene.plugins.blender.utils.Pointer;
import com.jme3.texture.Texture;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MaterialHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(MaterialHelper.class.getName());
    protected static final float DEFAULT_SHININESS = 20.0f;
    public static final String TEXTURE_TYPE_COLOR = "DiffuseMap";
    public static final String TEXTURE_TYPE_NORMAL = "NormalMap";
    public static final String TEXTURE_TYPE_SPECULAR = "SpecularMap";
    public static final String TEXTURE_TYPE_GLOW = "GlowMap";
    public static final String TEXTURE_TYPE_ALPHA = "AlphaMap";
    protected float alpha = 1.0f;
    protected RenderState.FaceCullMode faceCullMode;

    public MaterialHelper(String blenderVersion) {
        super(blenderVersion);
    }

    public void setFaceCullMode(RenderState.FaceCullMode faceCullMode) {
        this.faceCullMode = faceCullMode;
    }

    public Material toMaterial(Structure structure, DataRepository dataRepository) throws BlenderFileException {
        LOGGER.log(Level.INFO, "Loading material.");
        if (structure == null) {
            return dataRepository.getDefaultMaterial();
        }
        Material result = (Material)dataRepository.getLoadedFeature(structure.getOldMemoryAddress(), DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
        if (result != null) {
            return result;
        }
        result = new Material(dataRepository.getAssetManager(), "Common/MatDefs/Light/Lighting.j3md");
        result.getAdditionalRenderState().setFaceCullMode(this.faceCullMode);
        String name = structure.getName();
        LOGGER.log(Level.INFO, "Material's name: " + name);
        result.setBoolean("UseVertexColor", true);
        result.setBoolean("UseMaterialColors", true);
        MaterialHelper materialHelper = (MaterialHelper)dataRepository.getHelper(MaterialHelper.class);
        DiffuseShader diffuseShader = materialHelper.getDiffuseShader(structure);
        result.setBoolean("Minnaert", diffuseShader == DiffuseShader.MINNAERT);
        result.setColor("Diffuse", materialHelper.getDiffuseColor(structure, diffuseShader));
        SpecularShader specularShader = materialHelper.getSpecularShader(structure);
        result.setBoolean("WardIso", specularShader == SpecularShader.WARDISO);
        result.setColor("Specular", materialHelper.getSpecularColor(structure, specularShader));
        result.setColor("Ambient", materialHelper.getAmbientColor(structure));
        result.setFloat("Shininess", materialHelper.getShininess(structure));
        if ((dataRepository.getBlenderKey().getFeaturesToLoad() & 1) != 0) {
            DynamicArray mtexs = (DynamicArray)structure.getFieldValue("mtex");
            for (int i = 0; i < mtexs.getTotalSize(); ++i) {
                Pointer p = (Pointer)mtexs.get(i);
                if (p.isNull()) continue;
                List<Structure> mtex = p.fetchData(dataRepository.getInputStream());
                if (mtex.size() == 1) {
                    Structure textureLink = mtex.get(0);
                    int texco = ((Number)textureLink.getFieldValue("texco")).intValue();
                    int mapto = ((Number)textureLink.getFieldValue("mapto")).intValue();
                    if (mapto == 0) continue;
                    Pointer pTex = (Pointer)textureLink.getFieldValue("tex");
                    Structure tex = pTex.fetchData(dataRepository.getInputStream()).get(0);
                    TextureHelper textureHelper = (TextureHelper)dataRepository.getHelper(TextureHelper.class);
                    Texture texture = textureHelper.getTexture(tex, dataRepository);
                    if (texture != null) {
                        if ((mapto & 1) != 0) {
                            result.setTexture(TEXTURE_TYPE_COLOR, texture);
                        }
                        if ((mapto & 2) != 0) {
                            result.setTexture(TEXTURE_TYPE_NORMAL, texture);
                        }
                        if ((mapto & 0x20) != 0) {
                            result.setTexture(TEXTURE_TYPE_SPECULAR, texture);
                        }
                        if ((mapto & 0x40) != 0) {
                            result.setTexture(TEXTURE_TYPE_GLOW, texture);
                        }
                        if ((mapto & 0x80) == 0) continue;
                        result.setTexture(TEXTURE_TYPE_ALPHA, texture);
                        continue;
                    }
                    LOGGER.log(Level.WARNING, "Texture not found!");
                    continue;
                }
                LOGGER.log(Level.WARNING, "Many textures. Not solved yet!");
            }
        }
        dataRepository.addLoadedFeatures(structure.getOldMemoryAddress(), structure.getName(), structure, result);
        return result;
    }

    public Material getNonTexturedMaterial(Material material, int imageType) {
        String[] textureParamNames = new String[]{TEXTURE_TYPE_COLOR, TEXTURE_TYPE_NORMAL, TEXTURE_TYPE_GLOW, TEXTURE_TYPE_SPECULAR, TEXTURE_TYPE_ALPHA};
        HashMap<String, Texture> textures = new HashMap<String, Texture>(textureParamNames.length);
        for (String textureParamName : textureParamNames) {
            Material.MatParamTexture matParamTexture = material.getTextureParam(textureParamName);
            if (matParamTexture == null) continue;
            textures.put(textureParamName, matParamTexture.getTextureValue());
        }
        if (textures.size() == 0) {
            return material;
        }
        for (Map.Entry textureParamName : textures.entrySet()) {
            String name = ((Texture)textureParamName.getValue()).getName();
            try {
                int type = Integer.parseInt(name);
                if (type != imageType) continue;
                material.clearParam((String)textureParamName.getKey());
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "The name of the texture does not contain the texture type value! {0} will not be removed!", name);
            }
        }
        Material result = material.clone();
        for (Map.Entry textureEntry : textures.entrySet()) {
            material.setTexture((String)textureEntry.getKey(), (Texture)textureEntry.getValue());
        }
        return result;
    }

    public boolean hasTexture(Material material, String textureType) {
        if (material != null) {
            return material.getTextureParam(textureType) != null;
        }
        return false;
    }

    public ColorRGBA getDiffuseColor(Structure materialStructure, DiffuseShader diffuseShader) {
        int commonMapto = ((Number)materialStructure.getFieldValue("mapto")).intValue();
        float r = ((Number)materialStructure.getFieldValue("r")).floatValue();
        float g = ((Number)materialStructure.getFieldValue("g")).floatValue();
        float b = ((Number)materialStructure.getFieldValue("b")).floatValue();
        if ((commonMapto & 1) == 1) {
            return new ColorRGBA(1.0f, 1.0f, 1.0f, this.alpha);
        }
        switch (diffuseShader) {
            case FRESNEL: 
            case ORENNAYAR: 
            case TOON: {
                break;
            }
            case MINNAERT: 
            case LAMBERT: {
                float ref = ((Number)materialStructure.getFieldValue("ref")).floatValue();
                r *= ref;
                g *= ref;
                b *= ref;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown diffuse shader type: " + diffuseShader.toString());
            }
        }
        return new ColorRGBA(r, g, b, this.alpha);
    }

    public DiffuseShader getDiffuseShader(Structure materialStructure) {
        int diff_shader = ((Number)materialStructure.getFieldValue("diff_shader")).intValue();
        return DiffuseShader.values()[diff_shader];
    }

    public ColorRGBA getAmbientColor(Structure materialStructure) {
        float r = ((Number)materialStructure.getFieldValue("ambr")).floatValue();
        float g = ((Number)materialStructure.getFieldValue("ambg")).floatValue();
        float b = ((Number)materialStructure.getFieldValue("ambb")).floatValue();
        return new ColorRGBA(r, g, b, this.alpha);
    }

    public SpecularShader getSpecularShader(Structure materialStructure) {
        int spec_shader = ((Number)materialStructure.getFieldValue("spec_shader")).intValue();
        return SpecularShader.values()[spec_shader];
    }

    public ColorRGBA getSpecularColor(Structure materialStructure, SpecularShader specularShader) {
        float r = ((Number)materialStructure.getFieldValue("specr")).floatValue();
        float g = ((Number)materialStructure.getFieldValue("specg")).floatValue();
        float b = ((Number)materialStructure.getFieldValue("specb")).floatValue();
        switch (specularShader) {
            case BLINN: 
            case COOKTORRENCE: 
            case TOON: 
            case WARDISO: {
                break;
            }
            case PHONG: {
                float spec = ((Number)materialStructure.getFieldValue("spec")).floatValue();
                r *= spec * 0.5f;
                g *= spec * 0.5f;
                b *= spec * 0.5f;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown specular shader type: " + specularShader.toString());
            }
        }
        return new ColorRGBA(r, g, b, this.alpha);
    }

    public float getShininess(Structure materialStructure) {
        float shininess = ((Number)materialStructure.getFieldValue("emit")).floatValue();
        return shininess > 0.0f ? shininess : 20.0f;
    }

    public Material[] getMaterials(Structure structureWithMaterials, DataRepository dataRepository) throws BlenderFileException {
        List<Structure> materialStructures;
        Pointer ppMaterials = (Pointer)structureWithMaterials.getFieldValue("mat");
        Material[] materials = null;
        if (!ppMaterials.isNull() && (materialStructures = ppMaterials.fetchData(dataRepository.getInputStream())) != null && materialStructures.size() > 0) {
            MaterialHelper materialHelper = (MaterialHelper)dataRepository.getHelper(MaterialHelper.class);
            materials = new Material[materialStructures.size()];
            int i = 0;
            for (Structure s : materialStructures) {
                Material material = (Material)dataRepository.getLoadedFeature(s.getOldMemoryAddress(), DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
                if (material == null) {
                    material = materialHelper.toMaterial(s, dataRepository);
                }
                materials[i++] = material;
            }
        }
        return materials;
    }

    public void clearState() {
        this.alpha = 1.0f;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpecularShader {
        COOKTORRENCE,
        PHONG,
        BLINN,
        TOON,
        WARDISO;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiffuseShader {
        LAMBERT,
        ORENNAYAR,
        TOON,
        MINNAERT,
        FRESNEL;

    }
}

