/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.listbox;

import java.util.ArrayList;
import java.util.List;

public class ListBoxFocusItem {
    private List<Integer> indizesToRemove = new ArrayList<Integer>();

    public void prepare() {
        this.indizesToRemove.clear();
    }

    public void registerIndex(int value) {
        this.indizesToRemove.add(value);
    }

    public int resolve(int focusIndex, int itemCount) {
        if (focusIndex == -1) {
            return -1;
        }
        if (itemCount == 0) {
            return -1;
        }
        if (this.indizesToRemove.isEmpty()) {
            return focusIndex;
        }
        int newFocusIndex = this.calcNewFocusIndex(focusIndex, this.indizesToRemove);
        if (newFocusIndex >= itemCount - this.indizesToRemove.size()) {
            newFocusIndex = itemCount - this.indizesToRemove.size() - 1;
        }
        return newFocusIndex;
    }

    private int calcNewFocusIndex(int focusIndex, List<Integer> indizesToRemove) {
        int newFocusIndex = focusIndex;
        for (int i = 0; i < indizesToRemove.size(); ++i) {
            int removeIdx = indizesToRemove.get(i);
            if (removeIdx >= newFocusIndex) continue;
            --newFocusIndex;
            this.decrementListEntries(indizesToRemove, i);
        }
        return newFocusIndex;
    }

    private void decrementListEntries(List<Integer> indizesToRemove, int startIdx) {
        for (int i = startIdx; i < indizesToRemove.size(); ++i) {
            indizesToRemove.set(i, indizesToRemove.get(i) - 1);
        }
    }
}

