/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.event;

import com.jme3.input.event.InputEvent;

public class KeyInputEvent
extends InputEvent {
    private int keyCode;
    private char keyChar;
    private boolean pressed;
    private boolean repeating;

    public KeyInputEvent(int keyCode, char keyChar, boolean pressed, boolean repeating) {
        this.keyCode = keyCode;
        this.keyChar = keyChar;
        this.pressed = pressed;
        this.repeating = repeating;
    }

    public char getKeyChar() {
        return this.keyChar;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public boolean isRepeating() {
        return this.repeating;
    }

    public boolean isReleased() {
        return !this.pressed;
    }

    public String toString() {
        String str = "Key(CODE=" + this.keyCode;
        if (this.keyChar != '\u0000') {
            str = str + ", CHAR=" + this.keyChar;
        }
        if (this.repeating) {
            return str + ", REPEATING)";
        }
        if (this.pressed) {
            return str + ", PRESSED)";
        }
        return str + ", RELEASED)";
    }
}

