/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.kernel.tcp;

import com.jme3.network.kernel.Endpoint;
import com.jme3.network.kernel.Kernel;
import com.jme3.network.kernel.KernelException;
import com.jme3.network.kernel.tcp.SelectorKernel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;

public class NioEndpoint
implements Endpoint {
    protected static final ByteBuffer CLOSE_MARKER = ByteBuffer.allocate(0);
    private long id;
    private SocketChannel socket;
    private SelectorKernel kernel;
    private ConcurrentLinkedQueue<ByteBuffer> outbound = new ConcurrentLinkedQueue();
    private boolean closing = false;

    public NioEndpoint(SelectorKernel kernel, long id, SocketChannel socket) {
        this.id = id;
        this.socket = socket;
        this.kernel = kernel;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean flushData) {
        if (flushData) {
            this.closing = true;
            this.send(CLOSE_MARKER, false, true);
            return;
        }
        try {
            this.kernel.closeEndpoint(this);
        }
        catch (IOException e) {
            throw new KernelException("Error closing endpoint for socket:" + this.socket, e);
        }
    }

    public long getId() {
        return this.id;
    }

    public String getAddress() {
        return String.valueOf(this.socket.socket().getRemoteSocketAddress());
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    protected void send(ByteBuffer data, boolean copy, boolean wakeup) {
        ByteBuffer buffer;
        if (!copy) {
            buffer = data;
        } else {
            buffer = ByteBuffer.allocate(data.remaining());
            buffer.put(data);
            buffer.flip();
        }
        this.outbound.add(buffer);
        if (wakeup) {
            this.kernel.wakeupSelector();
        }
    }

    protected ByteBuffer peekPending() {
        return this.outbound.peek();
    }

    protected ByteBuffer removePending() {
        return this.outbound.poll();
    }

    protected boolean hasPending() {
        return !this.outbound.isEmpty();
    }

    public void send(ByteBuffer data) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        if (this.closing) {
            throw new KernelException("Endpoint has been closed:" + this.socket);
        }
        this.send(data, true, true);
    }

    public String toString() {
        return "NioEndpoint[" + this.id + ", " + this.socket + "]";
    }
}

