/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.serializing.serializers;

import com.jme3.network.message.Message;
import com.jme3.network.serializing.Serializer;
import com.jme3.network.serializing.SerializerException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldSerializer
extends Serializer {
    private static Map<Class, SavedField[]> savedFields = new HashMap<Class, SavedField[]>();

    protected void checkClass(Class clazz) {
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Registration error: no-argument constructor not found on:" + clazz);
        }
    }

    @Override
    public void initialize(Class clazz) {
        this.checkClass(clazz);
        ArrayList fields = new ArrayList();
        for (Class processingClass = clazz; processingClass != Object.class && processingClass != Message.class; processingClass = processingClass.getSuperclass()) {
            Collections.addAll(fields, processingClass.getDeclaredFields());
        }
        ArrayList<SavedField> cachedFields = new ArrayList<SavedField>(fields.size());
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            if (Modifier.isTransient(modifiers) || Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers) || field.isSynthetic()) continue;
            field.setAccessible(true);
            SavedField cachedField = new SavedField();
            cachedField.field = field;
            if (Modifier.isFinal(field.getType().getModifiers())) {
                cachedField.serializer = Serializer.getSerializer(field.getType(), false);
            }
            cachedFields.add(cachedField);
        }
        Collections.sort(cachedFields, new Comparator<SavedField>(){

            @Override
            public int compare(SavedField o1, SavedField o2) {
                return o1.field.getName().compareTo(o2.field.getName());
            }
        });
        savedFields.put(clazz, cachedFields.toArray(new SavedField[cachedFields.size()]));
    }

    @Override
    public <T> T readObject(ByteBuffer data, Class<T> c) throws IOException {
        T object;
        if (data.get() == 0) {
            return null;
        }
        SavedField[] fields = savedFields.get(c);
        try {
            object = c.newInstance();
        }
        catch (Exception e) {
            throw new SerializerException("Error creating object of type:" + c, e);
        }
        for (SavedField savedField : fields) {
            Field field = savedField.field;
            Serializer serializer = savedField.serializer;
            Object value = serializer != null ? serializer.readObject(data, field.getType()) : Serializer.readClassAndObject(data);
            try {
                field.set(object, value);
            }
            catch (IllegalAccessException e) {
                throw new SerializerException("Error reading object", e);
            }
        }
        return object;
    }

    @Override
    public void writeObject(ByteBuffer buffer, Object object) throws IOException {
        buffer.put((byte)(object != null ? 1 : 0));
        if (object == null) {
            return;
        }
        SavedField[] fields = savedFields.get(object.getClass());
        if (fields == null) {
            throw new IOException("The " + object.getClass() + " is not registered" + " in the serializer!");
        }
        for (SavedField savedField : fields) {
            Object val = null;
            try {
                val = savedField.field.get(object);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            Serializer serializer = savedField.serializer;
            try {
                if (serializer != null) {
                    serializer.writeObject(buffer, val);
                    continue;
                }
                Serializer.writeClassAndObject(buffer, val);
            }
            catch (BufferOverflowException boe) {
                throw boe;
            }
            catch (Exception e) {
                log.log(Level.WARNING, "[FieldSerializer][???] Exception occurred on writing. Maybe you've forgotten to register a class, or maybe a class member does not have a serializer.");
                throw new SerializerException("Error writing object", e);
            }
        }
    }

    private final class SavedField {
        public Field field;
        public Serializer serializer;

        private SavedField() {
        }
    }
}

