/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap.lodcalc;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Vector3f;
import com.jme3.terrain.geomipmap.TerrainPatch;
import com.jme3.terrain.geomipmap.UpdatedTerrainPatch;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculator;
import com.jme3.terrain.geomipmap.lodcalc.LodThreshold;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistanceLodCalculator
implements LodCalculator {
    private TerrainPatch terrainPatch;
    private LodThreshold lodThresholdCalculator;

    public DistanceLodCalculator() {
    }

    public DistanceLodCalculator(LodThreshold lodThresholdCalculator) {
        this.lodThresholdCalculator = lodThresholdCalculator;
    }

    public DistanceLodCalculator(TerrainPatch terrainPatch, LodThreshold lodThresholdCalculator) {
        this.terrainPatch = terrainPatch;
        this.lodThresholdCalculator = lodThresholdCalculator;
    }

    @Override
    public boolean calculateLod(List<Vector3f> locations, HashMap<String, UpdatedTerrainPatch> updates) {
        float distance = this.getCenterLocation().distance(locations.get(0));
        for (int i = 0; i <= this.terrainPatch.getMaxLod(); ++i) {
            if (!(distance < this.lodThresholdCalculator.getLodDistanceThreshold() * (float)(i + 1) * this.terrainPatch.getWorldScale().x) && i != this.terrainPatch.getMaxLod()) continue;
            boolean reIndexNeeded = false;
            if (i != this.terrainPatch.getLod()) {
                reIndexNeeded = true;
            }
            int prevLOD = this.terrainPatch.getLod();
            UpdatedTerrainPatch utp = updates.get(this.terrainPatch.getName());
            if (utp == null) {
                utp = new UpdatedTerrainPatch(this.terrainPatch, i);
                updates.put(utp.getName(), utp);
            }
            utp.setPreviousLod(prevLOD);
            utp.setReIndexNeeded(reIndexNeeded);
            return reIndexNeeded;
        }
        return false;
    }

    public Vector3f getCenterLocation() {
        Vector3f loc = this.terrainPatch.getWorldTranslation().clone();
        loc.x += (float)this.terrainPatch.getSize() * this.terrainPatch.getWorldScale().x / 2.0f;
        loc.z += (float)this.terrainPatch.getSize() * this.terrainPatch.getWorldScale().z / 2.0f;
        return loc;
    }

    @Override
    public void setTerrainPatch(TerrainPatch terrainPatch) {
        this.terrainPatch = terrainPatch;
    }

    protected LodThreshold getLodThreshold() {
        return this.lodThresholdCalculator;
    }

    protected void setLodThreshold(LodThreshold lodThresholdCalculator) {
        this.lodThresholdCalculator = lodThresholdCalculator;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.lodThresholdCalculator, "lodThresholdCalculator", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.lodThresholdCalculator = (LodThreshold)ic.readSavable("lodThresholdCalculator", null);
    }

    @Override
    public LodCalculator clone() {
        DistanceLodCalculator clone = new DistanceLodCalculator();
        clone.lodThresholdCalculator = this.lodThresholdCalculator.clone();
        return clone;
    }

    public String toString() {
        return "DistanceLodCalculator " + this.lodThresholdCalculator.toString();
    }

    @Override
    public boolean usesVariableLod() {
        return false;
    }
}

