/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.CollectorBase;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.LocalVariable;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.classreader.SymbolGathererStrategy;

public class SymbolGatherer
extends CollectorBase {
    private SymbolGathererStrategy strategy;
    private Method_info currentMethod = null;

    public SymbolGatherer(SymbolGathererStrategy strategy) {
        this.strategy = strategy;
    }

    void setCurrentMethodForTesting(Method_info entry) {
        this.currentMethod = entry;
    }

    @Override
    public void visitClassfile(Classfile classfile) {
        if (this.strategy.isMatching(classfile)) {
            this.add(classfile.getClassName());
        }
        super.visitClassfile(classfile);
    }

    @Override
    public void visitField_info(Field_info entry) {
        if (this.strategy.isMatching(entry)) {
            this.add(entry.getFullSignature());
        }
        super.visitField_info(entry);
    }

    @Override
    public void visitMethod_info(Method_info entry) {
        if (this.strategy.isMatching(entry)) {
            this.add(entry.getFullSignature());
        }
        Method_info previousMethod = this.currentMethod;
        this.currentMethod = entry;
        super.visitMethod_info(entry);
        this.currentMethod = previousMethod;
    }

    @Override
    public void visitLocalVariable(LocalVariable helper) {
        if (this.strategy.isMatching(helper)) {
            this.add(this.currentMethod.getFullSignature() + ": " + helper.getName());
        }
        super.visitLocalVariable(helper);
    }
}

