/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.DescriptorHelper;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.LocalVariableTable_attribute;
import com.jeantessier.classreader.impl.UTF8_info;
import java.io.DataInput;
import java.io.IOException;
import org.apache.log4j.Logger;

public class LocalVariable
implements com.jeantessier.classreader.LocalVariable {
    private LocalVariableTable_attribute localVariableTable;
    private int startPC;
    private int length;
    private int nameIndex;
    private int descriptorIndex;
    private int index;

    public LocalVariable(LocalVariableTable_attribute localVariableTable, DataInput in) throws IOException {
        this.localVariableTable = localVariableTable;
        this.startPC = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("start PC: " + this.startPC));
        this.length = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("length: " + this.length));
        this.nameIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("name: " + this.nameIndex + " (" + this.getName() + ")"));
        this.descriptorIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("descriptor: " + this.descriptorIndex + " (" + this.getDescriptor() + ")"));
        this.index = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("index: " + this.index));
    }

    @Override
    public LocalVariableTable_attribute getLocalVariableTable() {
        return this.localVariableTable;
    }

    @Override
    public int getStartPC() {
        return this.startPC;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getNameIndex() {
        return this.nameIndex;
    }

    @Override
    public UTF8_info getRawName() {
        return (UTF8_info)this.getLocalVariableTable().getConstantPool().get(this.getNameIndex());
    }

    @Override
    public String getName() {
        return this.getRawName().getValue();
    }

    @Override
    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    @Override
    public UTF8_info getRawDescriptor() {
        return (UTF8_info)this.getLocalVariableTable().getConstantPool().get(this.getDescriptorIndex());
    }

    @Override
    public String getDescriptor() {
        return this.getRawDescriptor().getValue();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return DescriptorHelper.getType(this.getDescriptor()) + " " + this.getName();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLocalVariable(this);
    }
}

