/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.Visitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;

public class ClassNode
extends Node {
    private PackageNode packageNode;
    private Collection<FeatureNode> features = new HashSet<FeatureNode>();
    private Collection<ClassNode> parents = new HashSet<ClassNode>();
    private Collection<ClassNode> children = new HashSet<ClassNode>();

    public ClassNode(PackageNode packageNode, String name, boolean concrete) {
        super(name, concrete);
        this.packageNode = packageNode;
    }

    public String getSimpleName() {
        return this.getName().substring(this.getName().lastIndexOf(46) + 1);
    }

    @Override
    void setConfirmed(boolean confirmed) {
        if (!confirmed) {
            for (FeatureNode featureNode : this.getFeatures()) {
                featureNode.setConfirmed(false);
            }
        }
        super.setConfirmed(confirmed);
        this.getPackageNode().setConfirmed(confirmed);
    }

    public PackageNode getPackageNode() {
        return this.packageNode;
    }

    public void addFeature(FeatureNode node) {
        this.features.add(node);
    }

    public void removeFeature(FeatureNode node) {
        this.features.remove(node);
    }

    public Collection<FeatureNode> getFeatures() {
        return Collections.unmodifiableCollection(this.features);
    }

    @Override
    public boolean canAddDependencyTo(Node node) {
        return super.canAddDependencyTo(node) && this.getPackageNode().canAddDependencyTo(node);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitClassNode(this);
    }

    @Override
    public void acceptInbound(Visitor visitor) {
        visitor.visitInboundClassNode(this);
    }

    @Override
    public void acceptOutbound(Visitor visitor) {
        visitor.visitOutboundClassNode(this);
    }

    public void addParent(ClassNode parentClass) {
        this.parents.add(parentClass);
        parentClass.children.add(this);
    }

    public Collection<ClassNode> getParents() {
        return Collections.unmodifiableCollection(this.parents);
    }

    public Collection<ClassNode> getChildren() {
        return Collections.unmodifiableCollection(this.children);
    }

    public FeatureNode getFeature(String featureSimpleName) {
        FeatureNode result = null;
        String targetName = this.getName() + "." + featureSimpleName;
        for (FeatureNode feature : this.getFeatures()) {
            if (!feature.getName().equals(targetName)) continue;
            result = feature;
        }
        return result;
    }

    public Collection<FeatureNode> getInheritedFeatures(String featureSimpleName) {
        LinkedList<FeatureNode> results = new LinkedList<FeatureNode>();
        FeatureNode featureNode = this.getFeature(featureSimpleName);
        if (featureNode != null) {
            results.add(featureNode);
        }
        for (ClassNode parent : this.getParents()) {
            results.addAll(parent.getInheritedFeatures(featureSimpleName));
        }
        return results;
    }
}

