/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClosureInboundSelector;
import com.jeantessier.dependency.ClosureLayerSelector;
import com.jeantessier.dependency.ClosureOutboundSelector;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.SelectionCriteria;
import com.jeantessier.dependency.TransitiveClosureEngine;
import java.util.Collection;

public class TransitiveClosure {
    public static final long DO_NOT_FOLLOW = -1L;
    public static final long UNBOUNDED_DEPTH = Long.MAX_VALUE;
    private long maximumInboundDepth = -1L;
    private long maximumOutboundDepth = Long.MAX_VALUE;
    private SelectionCriteria startCriteria;
    private SelectionCriteria stopCriteria;
    private NodeFactory factory = new NodeFactory();

    public TransitiveClosure(SelectionCriteria startCriteria, SelectionCriteria stopCriteria) {
        this.startCriteria = startCriteria;
        this.stopCriteria = stopCriteria;
    }

    public NodeFactory getFactory() {
        return this.factory;
    }

    public void setMaximumInboundDepth(long maximumInboundDepth) {
        this.maximumInboundDepth = maximumInboundDepth;
    }

    public void setMaximumOutboundDepth(long maximumOutboundDepth) {
        this.maximumOutboundDepth = maximumOutboundDepth;
    }

    public void traverseNodes(Collection<? extends Node> nodes) {
        if (this.maximumInboundDepth != -1L) {
            this.compute(nodes, this.maximumInboundDepth, new ClosureInboundSelector());
        }
        if (this.maximumOutboundDepth != -1L) {
            this.compute(nodes, this.maximumOutboundDepth, new ClosureOutboundSelector());
        }
    }

    private void compute(Collection<? extends Node> nodes, long depth, ClosureLayerSelector layerSelector) {
        TransitiveClosureEngine engine = new TransitiveClosureEngine(this.factory, nodes, this.startCriteria, this.stopCriteria, layerSelector);
        if (depth == Long.MAX_VALUE) {
            engine.computeAllLayers();
        } else {
            engine.computeLayers(depth);
        }
    }
}

