/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.Measurement;
import com.jeantessier.metrics.MeasurementBase;
import com.jeantessier.metrics.MeasurementDescriptor;
import com.jeantessier.metrics.MeasurementVisitor;
import com.jeantessier.metrics.Metrics;
import com.jeantessier.metrics.NullMeasurement;
import java.io.BufferedReader;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

public class StatisticalMeasurement
extends MeasurementBase {
    private static final NumberFormat valueFormat = new DecimalFormat("#.##");
    public static final int DISPOSE_IGNORE = 0;
    public static final int DISPOSE_MINIMUM = 1;
    public static final int DISPOSE_MEDIAN = 2;
    public static final int DISPOSE_AVERAGE = 3;
    public static final int DISPOSE_STANDARD_DEVIATION = 4;
    public static final int DISPOSE_MAXIMUM = 5;
    public static final int DISPOSE_SUM = 6;
    public static final int DISPOSE_NB_DATA_POINTS = 7;
    private String monitoredMeasurement;
    private int dispose;
    private int selfDispose;
    private List<Double> data = new LinkedList<Double>();
    private double minimum = 0.0;
    private double median = 0.0;
    private double average = 0.0;
    private double standardDeviation = 0.0;
    private double maximum = 0.0;
    private double sum = 0.0;
    private int nbDataPoints = 0;
    private int nbSubmetrics = -1;

    public static String getDisposeLabel(int dispose) {
        String result = "";
        switch (dispose) {
            case 1: {
                result = "minimum";
                break;
            }
            case 2: {
                result = "median";
                break;
            }
            case 3: {
                result = "average";
                break;
            }
            case 4: {
                result = "standard deviation";
                break;
            }
            case 5: {
                result = "maximum";
                break;
            }
            case 6: {
                result = "sum";
                break;
            }
            case 7: {
                result = "number of data points";
                break;
            }
        }
        return result;
    }

    public static String getDisposeAbbreviation(int dispose) {
        String result = "";
        switch (dispose) {
            case 1: {
                result = "min";
                break;
            }
            case 2: {
                result = "med";
                break;
            }
            case 3: {
                result = "avg";
                break;
            }
            case 4: {
                result = "sdv";
                break;
            }
            case 5: {
                result = "max";
                break;
            }
            case 6: {
                result = "sum";
                break;
            }
            case 7: {
                result = "nb";
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticalMeasurement(MeasurementDescriptor descriptor, Metrics context, String initText) {
        super(descriptor, context, initText);
        try {
            BufferedReader in = new BufferedReader(new StringReader(initText));
            this.monitoredMeasurement = in.readLine().trim();
            Perl5Util perl5Util = StatisticalMeasurement.perl();
            synchronized (perl5Util) {
                if (StatisticalMeasurement.perl().match("/(.*)\\s+(dispose_\\w+)$/i", this.monitoredMeasurement)) {
                    this.monitoredMeasurement = StatisticalMeasurement.perl().group(1);
                    String disposeText = StatisticalMeasurement.perl().group(2);
                    this.dispose = disposeText.equalsIgnoreCase("DISPOSE_IGNORE") ? 0 : (disposeText.equalsIgnoreCase("DISPOSE_MINIMUM") ? 1 : (disposeText.equalsIgnoreCase("DISPOSE_MEDIAN") ? 2 : (disposeText.equalsIgnoreCase("DISPOSE_AVERAGE") ? 3 : (disposeText.equalsIgnoreCase("DISPOSE_STANDARD_DEVIATION") ? 4 : (disposeText.equalsIgnoreCase("DISPOSE_MAXIMUM") ? 5 : (disposeText.equalsIgnoreCase("DISPOSE_SUM") ? 6 : (disposeText.equalsIgnoreCase("DISPOSE_NB_DATA_POINTS") ? 7 : 0)))))));
                } else {
                    this.dispose = 0;
                }
            }
            String selfDisposeText = in.readLine();
            this.selfDispose = selfDisposeText != null ? ((selfDisposeText = selfDisposeText.trim()).equalsIgnoreCase("DISPOSE_IGNORE") ? 0 : (selfDisposeText.equalsIgnoreCase("DISPOSE_MINIMUM") ? 1 : (selfDisposeText.equalsIgnoreCase("DISPOSE_MEDIAN") ? 2 : (selfDisposeText.equalsIgnoreCase("DISPOSE_AVERAGE") ? 3 : (selfDisposeText.equalsIgnoreCase("DISPOSE_STANDARD_DEVIATION") ? 4 : (selfDisposeText.equalsIgnoreCase("DISPOSE_MAXIMUM") ? 5 : (selfDisposeText.equalsIgnoreCase("DISPOSE_SUM") ? 6 : (selfDisposeText.equalsIgnoreCase("DISPOSE_NB_DATA_POINTS") ? 7 : 3)))))))) : 3;
            in.close();
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass()).debug((Object)("Cannot initialize with \"" + initText + "\""), (Throwable)ex);
            this.monitoredMeasurement = null;
        }
    }

    public double getMinimum() {
        this.collectData();
        return this.minimum;
    }

    public double getMedian() {
        this.collectData();
        return this.median;
    }

    public double getAverage() {
        this.collectData();
        return this.average;
    }

    public double getStandardDeviation() {
        this.collectData();
        return this.standardDeviation;
    }

    public double getMaximum() {
        this.collectData();
        return this.maximum;
    }

    public double getSum() {
        this.collectData();
        return this.sum;
    }

    public int getNbDataPoints() {
        this.collectData();
        return this.nbDataPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectData() {
        if (this.getContext().getSubMetrics().size() != this.nbSubmetrics) {
            StatisticalMeasurement statisticalMeasurement = this;
            synchronized (statisticalMeasurement) {
                if (this.getContext().getSubMetrics().size() != this.nbSubmetrics) {
                    this.data = new LinkedList<Double>();
                    this.setEmpty(true);
                    for (Metrics metrics : this.getContext().getSubMetrics()) {
                        this.visitMetrics(metrics);
                    }
                    if (!this.data.isEmpty()) {
                        Collections.sort(this.data);
                        this.minimum = this.data.get(0);
                        this.median = this.data.get(this.data.size() / 2);
                        this.maximum = this.data.get(this.data.size() - 1);
                        this.nbDataPoints = this.data.size();
                        this.sum = 0.0;
                        for (Double number : this.data) {
                            this.sum += number.doubleValue();
                        }
                    } else {
                        this.minimum = Double.NaN;
                        this.median = Double.NaN;
                        this.maximum = Double.NaN;
                        this.nbDataPoints = 0;
                        this.sum = 0.0;
                    }
                    this.average = this.sum / (double)this.nbDataPoints;
                    if (!this.data.isEmpty()) {
                        double temp = 0.0;
                        for (Double number : this.data) {
                            temp += Math.pow(number - this.average, 2.0);
                        }
                        this.standardDeviation = Math.sqrt(temp / (double)this.nbDataPoints);
                    } else {
                        this.standardDeviation = Double.NaN;
                    }
                    this.nbSubmetrics = this.getContext().getSubMetrics().size();
                }
            }
        }
    }

    private void visitMetrics(Metrics metrics) {
        Logger.getLogger(this.getClass()).debug((Object)("VisitMetrics: " + metrics.getName()));
        Measurement measurement = metrics.getMeasurement(this.monitoredMeasurement);
        Logger.getLogger(this.getClass()).debug((Object)("measurement for " + this.monitoredMeasurement + " is " + measurement.getClass()));
        if (measurement instanceof StatisticalMeasurement) {
            StatisticalMeasurement stats = (StatisticalMeasurement)measurement;
            Logger.getLogger(this.getClass()).debug((Object)("dispose of StatisticalMeasurements is " + this.dispose));
            switch (this.dispose) {
                case 1: {
                    Logger.getLogger(this.getClass()).debug((Object)("using Minimum(): " + stats.getMinimum()));
                    this.data.add(stats.getMinimum());
                    break;
                }
                case 2: {
                    Logger.getLogger(this.getClass()).debug((Object)("using Median(): " + stats.getMedian()));
                    this.data.add(stats.getMedian());
                    break;
                }
                case 3: {
                    Logger.getLogger(this.getClass()).debug((Object)("using Average(): " + stats.getAverage()));
                    this.data.add(stats.getAverage());
                    break;
                }
                case 4: {
                    Logger.getLogger(this.getClass()).debug((Object)("using StandardDeviation(): " + stats.getStandardDeviation()));
                    this.data.add(stats.getStandardDeviation());
                    break;
                }
                case 5: {
                    Logger.getLogger(this.getClass()).debug((Object)("using Maximum(): " + stats.getMaximum()));
                    this.data.add(stats.getMaximum());
                    break;
                }
                case 6: {
                    Logger.getLogger(this.getClass()).debug((Object)("using Sum(): " + stats.getSum()));
                    this.data.add(stats.getSum());
                    break;
                }
                case 7: {
                    Logger.getLogger(this.getClass()).debug((Object)("using NbDataPoints(): " + stats.getNbDataPoints()));
                    this.data.add(Double.valueOf(stats.getNbDataPoints()));
                    break;
                }
                default: {
                    Logger.getLogger(this.getClass()).debug((Object)"Skipping to next level ...");
                    for (Metrics subMetrics : metrics.getSubMetrics()) {
                        this.visitMetrics(subMetrics);
                    }
                }
            }
        } else if (measurement instanceof NullMeasurement) {
            Logger.getLogger(this.getClass()).debug((Object)"Skipping to next level ...");
            for (Metrics subMetrics : metrics.getSubMetrics()) {
                this.visitMetrics(subMetrics);
            }
        } else {
            Number value = measurement.getValue();
            Logger.getLogger(this.getClass()).debug((Object)(this.monitoredMeasurement + " on " + metrics.getName() + " is " + value));
            if (value != null) {
                this.data.add(value.doubleValue());
            }
        }
        if (super.isEmpty()) {
            this.setEmpty(measurement.isEmpty());
        }
    }

    @Override
    public boolean isEmpty() {
        this.collectData();
        return super.isEmpty();
    }

    @Override
    public void accept(MeasurementVisitor visitor) {
        visitor.visitStatisticalMeasurement(this);
    }

    @Override
    protected double compute() {
        double result = Double.NaN;
        switch (this.selfDispose) {
            case 1: {
                result = this.getMinimum();
                break;
            }
            case 2: {
                result = this.getMedian();
                break;
            }
            case 3: {
                result = this.getAverage();
                break;
            }
            case 4: {
                result = this.getStandardDeviation();
                break;
            }
            case 5: {
                result = this.getMaximum();
                break;
            }
            case 6: {
                result = this.getSum();
                break;
            }
            case 7: {
                result = this.getNbDataPoints();
                break;
            }
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[").append(valueFormat.format(this.getMinimum()));
        result.append(" ").append(valueFormat.format(this.getMedian()));
        result.append("/").append(valueFormat.format(this.getAverage()));
        result.append(" ").append(valueFormat.format(this.getStandardDeviation()));
        result.append(" ").append(valueFormat.format(this.getMaximum()));
        result.append(" ").append(valueFormat.format(this.getSum()));
        result.append(" (").append(valueFormat.format(this.getNbDataPoints())).append(")]");
        return result.toString();
    }
}

