/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.button.controller;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.elements.ControllerEventListener;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.layout.align.HorizontalAlign;
import de.lessvoid.nifty.layout.align.VerticalAlign;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;

public class ButtonControl
implements Controller {
    private Element element;
    private FocusHandler focusHandler;
    private Screen screen;

    public void bind(Nifty nifty, Screen screenParam, Element newElement, Properties parameter, ControllerEventListener listener, Attributes controlDefinitionAttributes) {
        this.element = newElement;
        this.screen = screenParam;
    }

    public void onStartScreen() {
        this.focusHandler = this.screen.getFocusHandler();
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        Element prevElement;
        if (inputEvent == NiftyInputEvent.NextInputElement) {
            this.focusHandler.getNext(this.element).setFocus();
            return true;
        }
        if (inputEvent == NiftyInputEvent.PrevInputElement) {
            this.focusHandler.getPrev(this.element).setFocus();
            return true;
        }
        if (inputEvent == NiftyInputEvent.Activate) {
            this.element.onClick();
            return true;
        }
        if (inputEvent == NiftyInputEvent.MoveCursorDown) {
            Element nextElement;
            if (this.focusHandler != null && (nextElement = this.focusHandler.getNext(this.element)).getParent().equals(this.element.getParent())) {
                nextElement.setFocus();
                return true;
            }
        } else if (inputEvent == NiftyInputEvent.MoveCursorUp && this.focusHandler != null && (prevElement = this.focusHandler.getPrev(this.element)).getParent().equals(this.element.getParent())) {
            prevElement.setFocus();
            return true;
        }
        return false;
    }

    public void setText(String text) {
        TextRenderer textRenderer = this.getButtonTextRenderer();
        textRenderer.setText(text);
        if (!textRenderer.isLineWrapping()) {
            this.buttonTextElement().setConstraintWidth(new SizeValue(textRenderer.getTextWidth() + "px"));
        }
    }

    public int getTextWidth() {
        return this.getButtonTextRenderer().getTextWidth();
    }

    public int getTextHeight() {
        return this.getButtonTextRenderer().getTextHeight();
    }

    public RenderFont getFont() {
        return this.getButtonTextRenderer().getFont();
    }

    public void setFont(RenderFont fontParam) {
        this.getButtonTextRenderer().setFont(fontParam);
    }

    public void setTextVAlign(VerticalAlign newTextVAlign) {
        this.getButtonTextRenderer().setTextVAlign(newTextVAlign);
    }

    public void setTextHAlign(HorizontalAlign newTextHAlign) {
        this.getButtonTextRenderer().setTextHAlign(newTextHAlign);
    }

    public void setColor(Color newColor) {
        this.getButtonTextRenderer().setColor(newColor);
    }

    private TextRenderer getButtonTextRenderer() {
        return (TextRenderer)this.buttonTextElement().getRenderer(TextRenderer.class);
    }

    private Element buttonTextElement() {
        return this.element.findElementByName("button-text");
    }
}

