/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.pulsate.Pulsator;

public class ColorPulsate
implements EffectImpl {
    private Color startColor;
    private Color endColor;
    private Pulsator pulsator;
    private Color currentColor = new Color("#000f");

    @Override
    public void activate(Nifty nifty, Element element, EffectProperties parameter) {
        this.startColor = new Color(parameter.getProperty("startColor", "#00000000"));
        this.endColor = new Color(parameter.getProperty("endColor", "#ffffffff"));
        this.pulsator = new Pulsator(parameter, nifty.getTimeProvider());
    }

    @Override
    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        float value = this.pulsator.update();
        this.currentColor.linear(this.startColor, this.endColor, value);
        r.setColor(this.currentColor);
    }

    @Override
    public void deactivate() {
    }
}

