/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.layout.manager;

import de.lessvoid.nifty.layout.Box;
import de.lessvoid.nifty.layout.BoxConstraints;
import de.lessvoid.nifty.layout.LayoutPart;
import de.lessvoid.nifty.layout.align.HorizontalAlign;
import de.lessvoid.nifty.layout.align.VerticalAlign;
import de.lessvoid.nifty.layout.manager.LayoutManager;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.List;

public class CenterLayout
implements LayoutManager {
    @Override
    public void layoutElements(LayoutPart rootElement, List<LayoutPart> elements) {
        if (rootElement == null || elements == null || elements.size() == 0) {
            return;
        }
        Box rootBox = rootElement.getBox();
        BoxConstraints rootBoxConstraints = rootElement.getBoxConstraints();
        for (int i = 0; i < elements.size(); ++i) {
            this.layoutElement(elements.get(i), rootBox, rootBoxConstraints);
        }
    }

    private int leftMargin(BoxConstraints boxConstraints, int rootBoxWidth) {
        return boxConstraints.getMarginLeft().getValueAsInt(rootBoxWidth);
    }

    private int rightMargin(BoxConstraints boxConstraints, int rootBoxWidth) {
        return boxConstraints.getMarginRight().getValueAsInt(rootBoxWidth);
    }

    private int topMargin(BoxConstraints boxConstraints, int rootBoxHeight) {
        return boxConstraints.getMarginTop().getValueAsInt(rootBoxHeight);
    }

    private int bottomMargin(BoxConstraints boxConstraints, int rootBoxHeight) {
        return boxConstraints.getMarginBottom().getValueAsInt(rootBoxHeight);
    }

    private void layoutElement(LayoutPart element, Box rootBox, BoxConstraints rootBoxConstraints) {
        Box box = element.getBox();
        BoxConstraints constraint = element.getBoxConstraints();
        if (constraint.getWidth() != null && constraint.getWidth().hasHeightSuffix()) {
            this.handleVerticalAlignment(rootBox, rootBoxConstraints, box, constraint);
            this.handleHorizontalAlignment(rootBox, rootBoxConstraints, box, constraint);
        } else if (constraint.getHeight() != null && constraint.getHeight().hasWidthSuffix()) {
            this.handleHorizontalAlignment(rootBox, rootBoxConstraints, box, constraint);
            this.handleVerticalAlignment(rootBox, rootBoxConstraints, box, constraint);
        } else {
            this.handleVerticalAlignment(rootBox, rootBoxConstraints, box, constraint);
            this.handleHorizontalAlignment(rootBox, rootBoxConstraints, box, constraint);
        }
        box.setX(box.getX() + this.leftMargin(constraint, rootBox.getWidth()) - this.rightMargin(constraint, rootBox.getWidth()));
        box.setY(box.getY() + this.topMargin(constraint, rootBox.getHeight()) - this.bottomMargin(constraint, rootBox.getHeight()));
    }

    void handleHorizontalAlignment(Box rootBox, BoxConstraints rootBoxConstraints, Box box, BoxConstraints constraint) {
        if (constraint.getWidth() != null) {
            this.handleWidthConstraint(rootBox, rootBoxConstraints, box, constraint);
        } else {
            box.setX(rootBox.getX() + rootBoxConstraints.getPaddingLeft().getValueAsInt(rootBox.getWidth()));
            box.setWidth(rootBox.getWidth() - rootBoxConstraints.getPaddingLeft().getValueAsInt(rootBox.getWidth()) - rootBoxConstraints.getPaddingRight().getValueAsInt(rootBox.getWidth()));
        }
    }

    void handleVerticalAlignment(Box rootBox, BoxConstraints rootBoxConstraints, Box box, BoxConstraints constraint) {
        if (constraint.getHeight() != null) {
            this.handleHeightConstraint(rootBox, rootBoxConstraints, box, constraint);
        } else {
            box.setY(rootBox.getY() + rootBoxConstraints.getPaddingTop().getValueAsInt(rootBox.getHeight()));
            box.setHeight(rootBox.getHeight() - rootBoxConstraints.getPaddingTop().getValueAsInt(rootBox.getHeight()) - rootBoxConstraints.getPaddingBottom().getValueAsInt(rootBox.getHeight()));
        }
    }

    private void handleWidthConstraint(Box rootBox, BoxConstraints rootBoxConstraints, Box box, BoxConstraints constraint) {
        int rootBoxX = rootBox.getX() + rootBoxConstraints.getPaddingLeft().getValueAsInt(rootBox.getWidth());
        int rootBoxWidth = rootBox.getWidth() - rootBoxConstraints.getPaddingLeft().getValueAsInt(rootBox.getWidth()) - rootBoxConstraints.getPaddingRight().getValueAsInt(rootBox.getWidth());
        int boxWidth = (int)constraint.getWidth().getValue(rootBoxWidth);
        if (constraint.getWidth().hasHeightSuffix()) {
            boxWidth = (int)constraint.getWidth().getValue(box.getHeight());
        }
        box.setWidth(boxWidth);
        if (constraint.getHorizontalAlign() == HorizontalAlign.left) {
            box.setX(rootBoxX);
        } else if (constraint.getHorizontalAlign() == HorizontalAlign.right) {
            box.setX(rootBoxX + rootBox.getWidth() - rootBoxConstraints.getPaddingRight().getValueAsInt(rootBox.getWidth()) - boxWidth);
        } else {
            box.setX(rootBoxX + (rootBoxWidth - boxWidth) / 2);
        }
    }

    private void handleHeightConstraint(Box rootBox, BoxConstraints rootBoxConstraints, Box box, BoxConstraints constraint) {
        int rootBoxY = rootBox.getY() + rootBoxConstraints.getPaddingTop().getValueAsInt(rootBox.getHeight());
        int rootBoxHeight = rootBox.getHeight() - rootBoxConstraints.getPaddingTop().getValueAsInt(rootBox.getHeight()) - rootBoxConstraints.getPaddingBottom().getValueAsInt(rootBox.getHeight());
        int boxHeight = (int)constraint.getHeight().getValue(rootBoxHeight);
        if (constraint.getHeight().hasWidthSuffix()) {
            boxHeight = (int)constraint.getHeight().getValue(box.getWidth());
        }
        box.setHeight(boxHeight);
        if (constraint.getVerticalAlign() == VerticalAlign.top) {
            box.setY(rootBoxY);
        } else if (constraint.getVerticalAlign() == VerticalAlign.bottom) {
            box.setY(rootBoxY + rootBox.getHeight() - rootBoxConstraints.getPaddingBottom().getValueAsInt(rootBox.getHeight()) - boxHeight);
        } else {
            box.setY(rootBoxY + (rootBoxHeight - boxHeight) / 2);
        }
    }

    @Override
    public SizeValue calculateConstraintWidth(LayoutPart root, List<LayoutPart> children) {
        return root.getMaxWidth(children);
    }

    @Override
    public SizeValue calculateConstraintHeight(LayoutPart root, List<LayoutPart> children) {
        return root.getMaxHeight(children);
    }
}

