/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.console;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.Console;
import de.lessvoid.nifty.controls.ConsoleExecuteCommandEvent;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.examples.NiftyExample;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyInputMapping;
import de.lessvoid.nifty.input.mapping.DefaultInputMapping;
import de.lessvoid.nifty.screen.KeyInputHandler;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;

public class ConsoleDemoStartScreen
implements ScreenController,
KeyInputHandler,
NiftyExample {
    private Nifty nifty;
    private Screen screen;
    private Element consolePopup;
    private boolean consoleVisible = false;
    private boolean allowConsoleToggle = true;
    private boolean firstConsoleShow = true;

    public void bind(Nifty newNifty, Screen newScreen) {
        this.nifty = newNifty;
        this.screen = newScreen;
        this.screen.addKeyboardInputHandler((NiftyInputMapping)new DefaultInputMapping(), (KeyInputHandler)this);
        this.consolePopup = this.nifty.createPopup("consolePopup");
    }

    public void onStartScreen() {
    }

    public void onEndScreen() {
    }

    public void back() {
        this.nifty.fromXml("all/intro.xml", "menu");
    }

    public boolean keyEvent(NiftyInputEvent inputEvent) {
        if (inputEvent == NiftyInputEvent.ConsoleToggle) {
            this.toggleConsole();
            return true;
        }
        return false;
    }

    private void toggleConsole() {
        if (this.allowConsoleToggle) {
            this.allowConsoleToggle = false;
            if (this.consoleVisible) {
                this.closeConsole();
            } else {
                this.openConsole();
            }
        }
    }

    private void openConsole() {
        this.nifty.showPopup(this.screen, this.consolePopup.getId(), this.consolePopup.findElementByName("console#textInput"));
        this.screen.processAddAndRemoveLayerElements();
        if (this.firstConsoleShow) {
            this.firstConsoleShow = false;
            Console console = (Console)this.screen.findNiftyControl("console", Console.class);
            console.output("Nifty Console Demo\nVersion: 2.0");
        }
        this.consoleVisible = true;
        this.allowConsoleToggle = true;
    }

    private void closeConsole() {
        this.nifty.closePopup(this.consolePopup.getId(), new EndNotify(){

            public void perform() {
                ConsoleDemoStartScreen.this.consoleVisible = false;
                ConsoleDemoStartScreen.this.allowConsoleToggle = true;
            }
        });
    }

    @NiftyEventSubscriber(id="console")
    public void onConsoleCommand(String id, ConsoleExecuteCommandEvent command) {
        Console console = (Console)this.screen.findNiftyControl("console", Console.class);
        console.output("your input was: " + command.getCommandLine() + " [" + command.getArgumentCount() + " parameter(s)]");
        if ("exit".equals(command.getCommand())) {
            this.back();
        }
    }

    @Override
    public String getStartScreen() {
        return "start";
    }

    @Override
    public String getMainXML() {
        return "console/console.xml";
    }

    @Override
    public String getTitle() {
        return "Nifty Console Demonstation";
    }

    @Override
    public void prepareStart(Nifty nifty) {
    }
}

