/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.rmi;

import com.jme3.network.HostedConnection;
import com.jme3.network.rmi.MethodDef;
import com.jme3.network.rmi.ObjectStore;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteObject
implements InvocationHandler {
    short objectId;
    MethodDef[] methodDefs;
    HashMap<Method, Integer> methodMap = new HashMap();
    ObjectStore store;
    HostedConnection client;

    public RemoteObject(ObjectStore store, HostedConnection client) {
        this.store = store;
        this.client = client;
    }

    private boolean methodEquals(MethodDef methodDef, Method method) {
        Class<?>[] defTypes;
        Class<?>[] interfaceTypes = method.getParameterTypes();
        if (interfaceTypes.length == (defTypes = methodDef.paramTypes).length) {
            for (int i = 0; i < interfaceTypes.length; ++i) {
                if (defTypes[i].isAssignableFrom(interfaceTypes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void loadMethods(Class<?> interfaceClass) {
        HashMap<String, ArrayList<Method>> nameToMethods = new HashMap<String, ArrayList<Method>>();
        for (Method method : interfaceClass.getDeclaredMethods()) {
            ArrayList<Method> list = (ArrayList<Method>)nameToMethods.get(method.getName());
            if (list == null) {
                list = new ArrayList<Method>();
                nameToMethods.put(method.getName(), list);
            }
            list.add(method);
        }
        block1: for (int i = 0; i < this.methodDefs.length; ++i) {
            MethodDef methodDef = this.methodDefs[i];
            ArrayList methods = (ArrayList)nameToMethods.get(methodDef.name);
            if (methods == null) continue;
            for (Method method : methods) {
                if (!this.methodEquals(methodDef, method)) continue;
                this.methodMap.put(method, i);
                continue block1;
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.store.invokeRemoteMethod(this, method, args);
    }
}

