/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shadow;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.shadow.ShadowUtil;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture2D;
import com.jme3.ui.Picture;

public class BasicShadowRenderer
implements SceneProcessor {
    private RenderManager renderManager;
    private ViewPort viewPort;
    private FrameBuffer shadowFB;
    private Texture2D shadowMap;
    private Camera shadowCam;
    private Material preshadowMat;
    private Material postshadowMat;
    private Picture dispPic = new Picture("Picture");
    private boolean noOccluders = false;
    private Vector3f[] points = new Vector3f[8];
    private Vector3f direction = new Vector3f();

    public BasicShadowRenderer(AssetManager manager, int size) {
        this.shadowFB = new FrameBuffer(size, size, 1);
        this.shadowMap = new Texture2D(size, size, Image.Format.Depth);
        this.shadowFB.setDepthTexture(this.shadowMap);
        this.shadowCam = new Camera(size, size);
        this.preshadowMat = new Material(manager, "Common/MatDefs/Shadow/PreShadow.j3md");
        this.postshadowMat = new Material(manager, "Common/MatDefs/Shadow/PostShadow.j3md");
        this.postshadowMat.setTexture("ShadowMap", this.shadowMap);
        this.dispPic.setTexture(manager, this.shadowMap, false);
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new Vector3f();
        }
    }

    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderManager = rm;
        this.viewPort = vp;
        this.reshape(vp, vp.getCamera().getWidth(), vp.getCamera().getHeight());
    }

    public boolean isInitialized() {
        return this.viewPort != null;
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public void setDirection(Vector3f direction) {
        this.direction.set(direction).normalizeLocal();
    }

    public Vector3f[] getPoints() {
        return this.points;
    }

    public Camera getShadowCamera() {
        return this.shadowCam;
    }

    public void postQueue(RenderQueue rq) {
        GeometryList occluders = rq.getShadowQueueContent(RenderQueue.ShadowMode.Cast);
        if (occluders.size() == 0) {
            this.noOccluders = true;
            return;
        }
        this.noOccluders = false;
        GeometryList receivers = rq.getShadowQueueContent(RenderQueue.ShadowMode.Receive);
        Camera viewCam = this.viewPort.getCamera();
        ShadowUtil.updateFrustumPoints(viewCam, viewCam.getFrustumNear(), viewCam.getFrustumFar(), 1.0f, this.points);
        Vector3f frustaCenter = new Vector3f();
        for (Vector3f point : this.points) {
            frustaCenter.addLocal(point);
        }
        frustaCenter.multLocal(0.125f);
        this.shadowCam.setProjectionMatrix(null);
        this.shadowCam.setParallelProjection(true);
        this.shadowCam.lookAtDirection(this.direction, Vector3f.UNIT_Y);
        this.shadowCam.update();
        this.shadowCam.setLocation(frustaCenter);
        this.shadowCam.update();
        this.shadowCam.updateViewProjection();
        ShadowUtil.updateShadowCamera(occluders, receivers, this.shadowCam, this.points);
        Renderer r = this.renderManager.getRenderer();
        this.renderManager.setCamera(this.shadowCam, false);
        this.renderManager.setForcedMaterial(this.preshadowMat);
        r.setFrameBuffer(this.shadowFB);
        r.clearBuffers(false, true, false);
        this.viewPort.getQueue().renderShadowQueue(RenderQueue.ShadowMode.Cast, this.renderManager, this.shadowCam, true);
        r.setFrameBuffer(this.viewPort.getOutputFrameBuffer());
        this.renderManager.setForcedMaterial(null);
        this.renderManager.setCamera(viewCam, false);
    }

    public Picture getDisplayPicture() {
        return this.dispPic;
    }

    public void postFrame(FrameBuffer out) {
        if (!this.noOccluders) {
            this.postshadowMat.setMatrix4("LightViewProjectionMatrix", this.shadowCam.getViewProjectionMatrix());
            this.renderManager.setForcedMaterial(this.postshadowMat);
            this.viewPort.getQueue().renderShadowQueue(RenderQueue.ShadowMode.Receive, this.renderManager, this.viewPort.getCamera(), true);
            this.renderManager.setForcedMaterial(null);
        }
    }

    public void preFrame(float tpf) {
    }

    public void cleanup() {
    }

    public void reshape(ViewPort vp, int w, int h) {
        this.dispPic.setPosition((float)w / 20.0f, (float)h / 20.0f);
        this.dispPic.setWidth((float)w / 5.0f);
        this.dispPic.setHeight((float)h / 5.0f);
    }
}

