/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.launch4j.ExecException;
import net.sf.launch4j.Log;
import net.sf.launch4j.Util;

class Cmd {
    private final List _cmd = new ArrayList();
    private final File _basedir;
    private final File _bindir;

    public Cmd(File basedir) {
        File bindir;
        this._basedir = basedir;
        String path = System.getProperty("launch4j.bindir");
        this._bindir = path == null ? new File(basedir, "bin") : ((bindir = new File(path)).isAbsolute() ? bindir : new File(basedir, path));
    }

    public Cmd add(String s) {
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            this._cmd.add(st.nextToken());
        }
        return this;
    }

    public Cmd addAbsFile(File file) {
        this._cmd.add(file.getPath());
        return this;
    }

    public Cmd addFile(String pathname) {
        this._cmd.add(new File(this._basedir, pathname).getPath());
        return this;
    }

    public Cmd addExe(String pathname) {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.indexOf("windows") != -1) {
            pathname = "bin-windows" + File.separator + pathname + ".exe";
        } else if (s.indexOf("mac") != -1) {
            pathname = "bin-macosx" + File.separator + pathname;
            new File(this._bindir, pathname).setExecutable(true);
        } else {
            pathname = "bin-linux" + File.separator + pathname;
            new File(this._bindir, pathname).setExecutable(true);
        }
        this._cmd.add(new File(this._bindir, pathname).getPath());
        return this;
    }

    public Cmd addFiles(List files) {
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            this.addFile((String)iter.next());
        }
        return this;
    }

    public void exec(Log log) throws ExecException {
        String[] cmd = this._cmd.toArray(new String[this._cmd.size()]);
        Util.exec(cmd, log);
    }
}

