/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.builder;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyStopwatch;
import de.lessvoid.nifty.builder.LayerBuilder;
import de.lessvoid.nifty.controls.dynamic.ScreenCreator;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import java.util.ArrayList;
import java.util.List;

public class ScreenBuilder {
    private ScreenCreator creator;
    private List<LayerBuilder> layerBuilders = new ArrayList<LayerBuilder>();

    public ScreenBuilder(String id) {
        this.creator = this.createScreenCreator(id);
    }

    public ScreenBuilder(String id, ScreenController controller) {
        this(id);
        this.creator.setScreenController(controller);
    }

    public void controller(ScreenController controller) {
        this.creator.setScreenController(controller);
    }

    public void defaultFocusElement(String defaultFocusElement) {
        this.creator.setDefaultFocusElement(defaultFocusElement);
    }

    public void inputMapping(String inputMapping) {
        this.creator.setInputMapping(inputMapping);
    }

    public void inputMappingPre(String inputMappingPre) {
        this.creator.setInputMappingPre(inputMappingPre);
    }

    public void layer(LayerBuilder layerBuilder) {
        this.layerBuilders.add(layerBuilder);
    }

    public Screen build(Nifty nifty) {
        NiftyStopwatch.start();
        Screen screen = this.creator.create(nifty);
        Element screenRootElement = screen.getRootElement();
        for (LayerBuilder layerBuilder : this.layerBuilders) {
            layerBuilder.build(nifty, screen, screenRootElement);
        }
        NiftyStopwatch.stop("ScreenBuilder.build ()");
        return screen;
    }

    ScreenCreator createScreenCreator(String id) {
        return new ScreenCreator(id);
    }
}

