/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.tabs;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Button;
import de.lessvoid.nifty.controls.ButtonClickedEvent;
import de.lessvoid.nifty.controls.Tab;
import de.lessvoid.nifty.controls.TabGroup;
import de.lessvoid.nifty.controls.TabSelectedEvent;
import de.lessvoid.nifty.controls.tabs.TabGroupMember;
import de.lessvoid.nifty.controls.tabs.builder.TabBuilder;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.events.ElementShowEvent;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.loaderv2.types.ElementType;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.bushe.swing.event.EventTopicSubscriber;

@Deprecated
public class TabGroupControl
extends AbstractController
implements TabGroup {
    private static final int BUTTON_LEFT_MARGIN = -16;
    private final Logger log = Logger.getLogger(TabGroupControl.class.getName());
    private final EventTopicSubscriber<ElementShowEvent> showEventSubscriber = new TabGroupShowEventSubscriber();
    private final EventTopicSubscriber<ButtonClickedEvent> buttonClickedSubscriber = new ButtonClickEventSubscriber(this);
    private Element tabButtonPanel;
    private Element contentPanel;
    private Nifty niftyGui;
    private Screen parentScreen;
    private ElementType buttonTemplate;
    private int selectedIndex = -1;

    @Override
    public void addTab(Element tab) {
        Tab tabControl = (Tab)tab.getNiftyControl(Tab.class);
        if (tabControl == null) {
            throw new IllegalArgumentException("Element to add is not a tab.");
        }
        this.addTab(tabControl);
    }

    @Override
    public void addTab(TabBuilder tabBuilder) {
        Element tab = tabBuilder.build(this.niftyGui, this.parentScreen, this.contentPanel);
        Tab tabControl = (Tab)tab.getNiftyControl(Tab.class);
        if (tabControl == null) {
            throw new IllegalStateException("Tab builder did not create a tab... WTF?!");
        }
        this.addTab(tabControl);
    }

    public void bind(Nifty nifty, Screen screen, Element element, Properties parameter, Attributes controlDefinitionAttributes) {
        this.bind(element);
        this.niftyGui = nifty;
        this.parentScreen = screen;
        this.tabButtonPanel = element.findElementByName("#tab-button-panel");
        this.contentPanel = element.findElementByName("#tab-content-panel");
        Element buttonElement = this.tabButtonPanel.findElementByName("#button-template");
        if (buttonElement == null) {
            throw new IllegalStateException("Required button template missing.");
        }
        this.buttonTemplate = buttonElement.getElementType().copy();
        nifty.removeElement(screen, buttonElement);
    }

    @Override
    public Tab getSelectedTab() {
        return this.selectedIndex == -1 ? null : (Tab)((Element)this.contentPanel.getElements().get(this.selectedIndex)).getNiftyControl(Tab.class);
    }

    @Override
    public int getSelectedTabIndex() {
        return this.selectedIndex;
    }

    public void init(Properties parameter, Attributes controlDefinitionAttributes) {
        super.init(parameter, controlDefinitionAttributes);
        for (Element element : this.contentPanel.getElements()) {
            Tab tabControl = (Tab)element.getNiftyControl(Tab.class);
            if (tabControl == null) {
                this.log.warning("Element without tab control detected. Removing: " + element.getId());
                element.markForRemoval();
                continue;
            }
            this.initTab(tabControl);
            this.selectedIndex = 0;
        }
        this.checkVisibility();
    }

    private void initTab(Tab tab) {
        Button btnControl;
        int tabIndex = this.indexOf(tab);
        Element button = this.getButton(tabIndex);
        if (button == null) {
            ElementType newButtonTemplate = this.buttonTemplate.copy();
            newButtonTemplate.getAttributes().set("id", this.buildTabButtonName(tabIndex));
            button = this.niftyGui.createElementFromType(this.parentScreen, this.tabButtonPanel, newButtonTemplate);
        }
        this.niftyGui.subscribe(this.parentScreen, button.getId(), ButtonClickedEvent.class, this.buttonClickedSubscriber);
        if (!button.isVisible()) {
            button.show();
        }
        if ((btnControl = (Button)button.getNiftyControl(Button.class)) == null) {
            this.log.warning("Can't set label of tab selection element that is not a button.");
        } else {
            btnControl.setText(tab.getCaption());
        }
        if (tab instanceof TabGroupMember) {
            ((TabGroupMember)((Object)tab)).setParentTabGroup(this);
        }
    }

    private String buildTabButtonName(int index) {
        return this.tabButtonPanel.getId() + "#tabButton-" + Integer.toString(index);
    }

    @Override
    public void addTab(Tab tab) {
        if (!tab.getElement().getParent().equals(this.contentPanel)) {
            tab.getElement().markForMove(this.contentPanel, (EndNotify)new TabAddMoveEndNotify(this, tab));
            return;
        }
        this.initTab(tab);
        this.checkVisibility();
    }

    @Override
    public int indexOf(Tab tab) {
        if (tab == null) {
            throw new NullPointerException("The tab can't be null");
        }
        int length = this.getTabCount();
        List elementList = this.contentPanel.getElements();
        int result = -1;
        for (int i = 0; i < length; ++i) {
            if (!tab.equals(((Element)elementList.get(i)).getNiftyControl(Tab.class))) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public int getTabCount() {
        return this.contentPanel.getElements().size();
    }

    private Element getButton(int index) {
        int realIndex = index;
        List buttonList = this.tabButtonPanel.getElements();
        if (buttonList.isEmpty()) {
            return null;
        }
        if (((Element)this.tabButtonPanel.getElements().get(0)).getId().endsWith("#button-template")) {
            ++realIndex;
        }
        if (realIndex >= buttonList.size()) {
            return null;
        }
        return (Element)this.tabButtonPanel.getElements().get(realIndex);
    }

    private Tab getTab(int index) {
        return (Tab)((Element)this.contentPanel.getElements().get(index)).getNiftyControl(Tab.class);
    }

    private void checkVisibility() {
        int length = this.getTabCount();
        List tabList = this.contentPanel.getElements();
        for (int i = 0; i < length; ++i) {
            Element tab = (Element)tabList.get(i);
            Element button = this.getButton(i);
            if (i == this.selectedIndex) {
                if (!tab.isVisible()) {
                    tab.show();
                }
                if (!"nifty-tab-button-active".equals(button.getStyle())) {
                    button.setStyle("nifty-tab-button-active");
                    this.addMargin(i, button);
                }
                button.setRenderOrder(100000);
                continue;
            }
            if (tab.isVisible()) {
                tab.hide();
            }
            if (!"nifty-tab-button".equals(button.getStyle())) {
                button.setStyle("nifty-tab-button");
                this.addMargin(i, button);
            }
            button.setRenderOrder(0);
        }
        this.getElement().layoutElements();
    }

    private void addMargin(int i, Element button) {
        if (i > 0) {
            button.setMarginLeft(SizeValue.px((int)-16));
        } else {
            button.setMarginLeft(SizeValue.px((int)0));
        }
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return true;
    }

    @Override
    public boolean isTabInGroup(Tab tab) {
        return this.indexOf(tab) > -1;
    }

    public void onStartScreen() {
        this.niftyGui.subscribe(this.parentScreen, this.getId(), ElementShowEvent.class, this.showEventSubscriber);
    }

    @Override
    public void removeTab(int index) {
        this.removeTab(index, null);
    }

    @Override
    public void removeTab(Tab tab) {
        this.removeTab(tab, null);
    }

    @Override
    public void removeTab(Element tab) {
        this.removeTab(tab, null);
    }

    @Override
    public void removeTab(int index, EndNotify notify) {
        if (index < 0 || index >= this.getTabCount()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        EndNotify triggeredNotification = notify;
        if (this.selectedIndex == index) {
            this.selectedIndex = Math.max(0, Math.min(this.selectedIndex, this.getTabCount() - 1));
            triggeredNotification = new CheckVisibilityEndNotify(this, triggeredNotification);
        }
        Element button = (Element)this.tabButtonPanel.getElements().get(index);
        this.niftyGui.unsubscribe(button.getId(), this.buttonClickedSubscriber);
        button.markForRemoval();
        ((Element)this.contentPanel.getElements().get(index)).markForRemoval(triggeredNotification);
    }

    @Override
    public void removeTab(Tab tab, EndNotify notify) {
        int index = this.indexOf(tab);
        if (index == -1) {
            throw new IllegalArgumentException("The tab to remove is not part of this tab group.");
        }
        this.removeTab(index, notify);
    }

    @Override
    public void removeTab(Element tab, EndNotify notify) {
        Tab tabControl = (Tab)tab.getNiftyControl(Tab.class);
        if (tabControl == null) {
            throw new IllegalArgumentException("Element to add is not a tab.");
        }
        this.removeTab(tabControl, notify);
    }

    @Override
    public void setSelectedTab(Tab tab) {
        int index = this.indexOf(tab);
        if (index == -1) {
            throw new IllegalArgumentException("The tab to remove is not part of this tab group.");
        }
        this.setSelectedTabIndex(index);
    }

    @Override
    public void setSelectedTabIndex(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        this.selectedIndex = index;
        this.checkVisibility();
        this.niftyGui.publishEvent(this.getId(), (NiftyEvent)new TabSelectedEvent(this, this.getTab(index), index));
    }

    @Override
    public void setTabCaption(int index, String caption) {
        if (index < 0 || index >= this.getTabCount()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        Tab tabControl = (Tab)((Element)this.contentPanel.getElements().get(index)).getNiftyControl(Tab.class);
        if (tabControl == null) {
            throw new IllegalStateException("Tab control corrupted for index: " + index);
        }
        tabControl.setCaption(caption);
        Button button = (Button)this.getButton(index).getNiftyControl(Button.class);
        if (button == null) {
            this.log.warning("Can't change caption in case template is not a button.");
        } else {
            button.setText(caption);
        }
    }

    @Override
    public void setTabCaption(Tab tab, String caption) {
        int index = this.indexOf(tab);
        if (index == -1) {
            throw new IllegalArgumentException("The tab to remove is not part of this tab group.");
        }
        this.setTabCaption(index, caption);
    }

    private void processButtonClick(Element clickedButton) {
        List buttons = this.tabButtonPanel.getElements();
        if (buttons.isEmpty()) {
            return;
        }
        int indexOffset = 0;
        if (((Element)buttons.get(0)).getId().endsWith("#button-template")) {
            indexOffset = -1;
        }
        this.setSelectedTabIndex(buttons.indexOf(clickedButton) + indexOffset);
    }

    private static final class TabAddMoveEndNotify
    implements EndNotify {
        private final TabGroupControl parentControl;
        private final Tab tabToAdd;

        private TabAddMoveEndNotify(TabGroupControl control, Tab tab) {
            this.parentControl = control;
            this.tabToAdd = tab;
        }

        public void perform() {
            this.parentControl.addTab(this.tabToAdd);
        }
    }

    private static final class CheckVisibilityEndNotify
    implements EndNotify {
        private final TabGroupControl parentControl;
        private final EndNotify next;

        private CheckVisibilityEndNotify(TabGroupControl control, EndNotify nextNotify) {
            this.parentControl = control;
            this.next = nextNotify;
        }

        public void perform() {
            this.parentControl.checkVisibility();
            if (this.next != null) {
                this.next.perform();
            }
        }
    }

    private static final class ButtonClickEventSubscriber
    implements EventTopicSubscriber<ButtonClickedEvent> {
        private final TabGroupControl parentControl;

        private ButtonClickEventSubscriber(TabGroupControl parent) {
            this.parentControl = parent;
        }

        public void onEvent(String topic, ButtonClickedEvent data) {
            this.parentControl.processButtonClick(data.getButton().getElement());
        }
    }

    private static final class TabGroupShowEventSubscriber
    implements EventTopicSubscriber<ElementShowEvent> {
        private TabGroupShowEventSubscriber() {
        }

        public void onEvent(String topic, ElementShowEvent data) {
            TabGroupControl control = (TabGroupControl)data.getElement().getControl(TabGroupControl.class);
            if (control != null) {
                control.checkVisibility();
            }
        }
    }
}

