/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.ComprehensiveTraversalStrategy;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.SortedTraversalStrategy;
import com.jeantessier.dependency.TraversalStrategy;
import com.jeantessier.dependency.VisitorBase;
import java.io.PrintWriter;
import java.util.Iterator;

public abstract class Printer
extends VisitorBase {
    public static final String DEFAULT_INDENT_TEXT = "    ";
    private PrintWriter out;
    private String indentText = "    ";
    private int indentLevel = 0;
    private boolean showInbounds = true;
    private boolean showOutbounds = true;
    private boolean showEmptyNodes = true;

    public Printer(PrintWriter out) {
        this(new SortedTraversalStrategy(new ComprehensiveTraversalStrategy()), out);
    }

    public Printer(TraversalStrategy strategy, PrintWriter out) {
        super(strategy);
        this.out = out;
    }

    public String getIndentText() {
        return this.indentText;
    }

    public void setIndentText(String indentText) {
        this.indentText = indentText;
    }

    public boolean isShowInbounds() {
        return this.showInbounds;
    }

    public void setShowInbounds(boolean showInbounds) {
        this.showInbounds = showInbounds;
    }

    public boolean isShowOutbounds() {
        return this.showOutbounds;
    }

    public void setShowOutbounds(boolean showOutbounds) {
        this.showOutbounds = showOutbounds;
    }

    public boolean isShowEmptyNodes() {
        return this.showEmptyNodes;
    }

    public void setShowEmptyNodes(boolean showEmptyNodes) {
        this.showEmptyNodes = showEmptyNodes;
    }

    protected Printer append(boolean b) {
        this.out.print(b);
        return this;
    }

    protected Printer append(char c) {
        this.out.print(c);
        return this;
    }

    protected Printer append(char[] s) {
        this.out.print(s);
        return this;
    }

    protected Printer append(double d) {
        this.out.print(d);
        return this;
    }

    protected Printer append(float f) {
        this.out.print(f);
        return this;
    }

    protected Printer append(int i) {
        this.out.print(i);
        return this;
    }

    protected Printer append(long l) {
        this.out.print(l);
        return this;
    }

    protected Printer append(Object obj) {
        this.out.print(obj);
        return this;
    }

    protected Printer append(String s) {
        this.out.print(s);
        return this;
    }

    protected Printer indent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.append(this.getIndentText());
        }
        return this;
    }

    protected Printer eol() {
        this.out.println();
        return this;
    }

    protected final Printer printScopeNodeName(Node node) {
        return this.printScopeNodeName(node, node.getName());
    }

    protected Printer printScopeNodeName(Node node, String name) {
        return this.printNodeName(node, name);
    }

    protected final Printer printDependencyNodeName(Node node) {
        return this.printDependencyNodeName(node, node.getName());
    }

    protected Printer printDependencyNodeName(Node node, String name) {
        return this.printNodeName(node, name);
    }

    protected Printer printNodeName(Node node, String name) {
        return this.append(name);
    }

    protected void raiseIndent() {
        ++this.indentLevel;
    }

    protected void lowerIndent() {
        --this.indentLevel;
    }

    protected boolean shouldShowPackageNode(PackageNode node) {
        boolean result = this.shouldShowNode(node);
        Iterator<ClassNode> i = node.getClasses().iterator();
        while (!result && i.hasNext()) {
            result = this.shouldShowClassNode(i.next());
        }
        return result;
    }

    protected boolean shouldShowClassNode(ClassNode node) {
        boolean result = this.shouldShowNode(node);
        Iterator<FeatureNode> i = node.getFeatures().iterator();
        while (!result && i.hasNext()) {
            result = this.shouldShowFeatureNode(i.next());
        }
        return result;
    }

    protected boolean shouldShowFeatureNode(FeatureNode node) {
        return this.shouldShowNode(node);
    }

    protected boolean shouldShowNode(Node node) {
        boolean result = this.isShowEmptyNodes();
        if (!result) {
            result = this.isShowOutbounds() && !node.getOutboundDependencies().isEmpty() || this.isShowInbounds() && !node.getInboundDependencies().isEmpty();
        }
        return result;
    }
}

