/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.LCOM4Gatherer;
import com.jeantessier.dependencyfinder.cli.DependencyGraphCommand;
import com.jeantessier.dependencyfinder.cli.OOMetrics;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClassCohesion
extends DependencyGraphCommand {
    private static final String DEFAULT_ENCODING = "utf-8";
    private static final String DEFAULT_DTD_PREFIX = "http://depfind.sourceforge.net/dtd";
    private static final String DEFAULT_INDENT_TEXT = "    ";

    @Override
    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.populateCommandLineSwitchesForXMLOutput(DEFAULT_ENCODING, DEFAULT_DTD_PREFIX, DEFAULT_INDENT_TEXT);
        this.getCommandLine().addToggleSwitch("csv");
        this.getCommandLine().addToggleSwitch("txt");
        this.getCommandLine().addToggleSwitch("xml");
        this.getCommandLine().addToggleSwitch("list");
    }

    @Override
    protected Collection<CommandLineException> parseCommandLine(String[] args) {
        Collection<CommandLineException> exceptions = super.parseCommandLine(args);
        int modeSwitch = 0;
        if (this.getCommandLine().getToggleSwitch("csv")) {
            ++modeSwitch;
        }
        if (this.getCommandLine().getToggleSwitch("txt")) {
            ++modeSwitch;
        }
        if (this.getCommandLine().getToggleSwitch("xml")) {
            ++modeSwitch;
        }
        if (modeSwitch != 1) {
            exceptions.add(new CommandLineException("Must have one and only one of -csv, -txt, or -xml"));
        }
        return exceptions;
    }

    @Override
    public void doProcessing() throws Exception {
        LCOM4Gatherer gatherer = new LCOM4Gatherer();
        Logger.getLogger(OOMetrics.class).debug((Object)"Reading classes and computing metrics as we go ...");
        this.getVerboseListener().print("Reading classes and computing metrics as we go ...");
        gatherer.traverseNodes(this.loadGraph().getPackages().values());
        Logger.getLogger(OOMetrics.class).debug((Object)"Printing results ...");
        this.getVerboseListener().print("Printing results ...");
        if (this.getCommandLine().isPresent("csv")) {
            this.printCSVFiles(gatherer.getResults());
        } else if (this.getCommandLine().isPresent("txt")) {
            this.printTextFile(gatherer.getResults());
        } else if (this.getCommandLine().isPresent("xml")) {
            this.printXMLFile(gatherer.getResults());
        }
        Logger.getLogger(OOMetrics.class).debug((Object)"Done.");
    }

    private void printCSVFiles(Map<ClassNode, Collection<Collection<FeatureNode>>> results) throws IOException {
        this.getOut().println("class, LCOM4");
        for (Map.Entry<ClassNode, Collection<Collection<FeatureNode>>> entry : results.entrySet()) {
            this.getOut().println(entry.getKey().getName() + ", " + entry.getValue().size());
        }
    }

    private void printTextFile(Map<ClassNode, Collection<Collection<FeatureNode>>> results) throws IOException {
        String indentText = this.getCommandLine().getSingleSwitch("indent-text");
        for (Map.Entry<ClassNode, Collection<Collection<FeatureNode>>> entry : results.entrySet()) {
            this.getOut().println(entry.getKey().getName() + ": " + entry.getValue().size());
            if (entry.getValue().size() <= 1 || !this.getCommandLine().isPresent("list")) continue;
            this.getOut().println(indentText + "--------");
            for (Collection<FeatureNode> component : entry.getValue()) {
                for (FeatureNode feature : component) {
                    this.getOut().println(indentText + feature.getName().substring(feature.getClassNode().getName().length() + 1));
                }
                this.getOut().println(indentText + "--------");
            }
        }
    }

    private void printXMLFile(Map<ClassNode, Collection<Collection<FeatureNode>>> results) throws IOException {
        String indentText = this.getCommandLine().getSingleSwitch("indent-text");
        this.getOut().println("<classes>");
        for (Map.Entry<ClassNode, Collection<Collection<FeatureNode>>> entry : results.entrySet()) {
            if (entry.getValue().size() > 1) {
                this.getOut().println(indentText + "<class name=\"" + entry.getKey().getName() + "\" lcom4=\"" + entry.getValue().size() + "\">");
                for (Collection<FeatureNode> component : entry.getValue()) {
                    this.getOut().println(indentText + indentText + "<component>");
                    for (FeatureNode feature : component) {
                        this.getOut().println(indentText + indentText + indentText + "<feature name=\"" + feature.getName() + "\"/>");
                    }
                    this.getOut().println(indentText + indentText + "</component>");
                }
                this.getOut().println(indentText + "</class>");
                continue;
            }
            this.getOut().println(indentText + "<class name=\"" + entry.getKey().getName() + "\" lcom4=\"" + entry.getValue().size() + "\"/>");
        }
        this.getOut().println("</classes>");
    }

    public static void main(String[] args) throws Exception {
        new ClassCohesion().run(args);
    }
}

