/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.DefaultSymbolGathererStrategy;
import com.jeantessier.classreader.FilteringSymbolGathererStrategy;
import com.jeantessier.classreader.FinalMethodOrClassSymbolGathererStrategy;
import com.jeantessier.classreader.LoadListenerVisitorAdapter;
import com.jeantessier.classreader.NonPrivateFieldSymbolGathererStrategy;
import com.jeantessier.classreader.SymbolGatherer;
import com.jeantessier.classreader.SymbolGathererStrategy;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.dependencyfinder.cli.DirectoryExplorerCommand;
import java.util.Collection;

public class ListSymbols
extends DirectoryExplorerCommand {
    @Override
    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.getCommandLine().addToggleSwitch("class-names");
        this.getCommandLine().addToggleSwitch("field-names");
        this.getCommandLine().addToggleSwitch("method-names");
        this.getCommandLine().addToggleSwitch("local-names");
        this.getCommandLine().addToggleSwitch("non-private-field-names");
        this.getCommandLine().addToggleSwitch("final-method-or-class-names");
        this.getCommandLine().addMultipleValuesSwitch("includes", "//");
        this.getCommandLine().addMultipleValuesSwitch("excludes");
    }

    @Override
    protected Collection<CommandLineException> parseCommandLine(String[] args) {
        Collection<CommandLineException> exceptions = super.parseCommandLine(args);
        if (!(this.getCommandLine().isPresent("class-names") || this.getCommandLine().isPresent("field-names") || this.getCommandLine().isPresent("method-names") || this.getCommandLine().isPresent("local-names"))) {
            this.getCommandLine().getSwitch("class-names").setValue(true);
            this.getCommandLine().getSwitch("field-names").setValue(true);
            this.getCommandLine().getSwitch("method-names").setValue(true);
            this.getCommandLine().getSwitch("local-names").setValue(true);
        }
        return exceptions;
    }

    @Override
    protected void doProcessing() throws Exception {
        SymbolGathererStrategy gathererStrategy;
        if (this.getCommandLine().getToggleSwitch("non-private-field-names")) {
            gathererStrategy = new NonPrivateFieldSymbolGathererStrategy();
        } else if (this.getCommandLine().getToggleSwitch("final-method-or-class-names")) {
            gathererStrategy = new FinalMethodOrClassSymbolGathererStrategy();
        } else {
            DefaultSymbolGathererStrategy defaultGathererStrategy = new DefaultSymbolGathererStrategy();
            defaultGathererStrategy.setMatchingClassNames(this.getCommandLine().getToggleSwitch("class-names"));
            defaultGathererStrategy.setMatchingFieldNames(this.getCommandLine().getToggleSwitch("field-names"));
            defaultGathererStrategy.setMatchingMethodNames(this.getCommandLine().getToggleSwitch("method-names"));
            defaultGathererStrategy.setMatchingLocalNames(this.getCommandLine().getToggleSwitch("local-names"));
            gathererStrategy = defaultGathererStrategy;
        }
        if (this.getCommandLine().isPresent("includes") || this.getCommandLine().isPresent("excludes")) {
            gathererStrategy = new FilteringSymbolGathererStrategy(gathererStrategy, this.getCommandLine().getMultipleSwitch("includes"), this.getCommandLine().getMultipleSwitch("excludes"));
        }
        SymbolGatherer gatherer = new SymbolGatherer(gathererStrategy);
        TransientClassfileLoader loader = new TransientClassfileLoader();
        ((ClassfileLoader)loader).addLoadListener(new LoadListenerVisitorAdapter(gatherer));
        ((ClassfileLoader)loader).addLoadListener(this.getVerboseListener());
        loader.load(this.getCommandLine().getParameters());
        for (String symbol : gatherer.getCollection()) {
            this.getOut().println(symbol);
        }
    }

    public static void main(String[] args) throws Exception {
        new ListSymbols().run(args);
    }
}

