/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.MeasurementDescriptor;
import com.jeantessier.metrics.MetricsConfiguration;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MetricsConfigurationHandler
extends DefaultHandler {
    private static final int PROJECT = 0;
    private static final int GROUP = 1;
    private static final int CLASS = 2;
    private static final int METHOD = 3;
    private MetricsConfiguration configuration;
    private int section;
    private MeasurementDescriptor descriptor;
    private String name;
    private String pattern;
    private StringBuffer currentName = new StringBuffer();

    public MetricsConfigurationHandler() {
        this(new MetricsConfiguration());
    }

    public MetricsConfigurationHandler(MetricsConfiguration configuration) {
        this.configuration = configuration;
    }

    public MetricsConfiguration getMetricsConfiguration() {
        return this.configuration;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Logger.getLogger(this.getClass()).debug((Object)("startElement qName = " + qName));
        for (int i = 0; i < atts.getLength(); ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("    " + atts.getQName(i) + ": " + atts.getValue(i)));
        }
        this.currentName.delete(0, this.currentName.length());
        if (qName.equals("project-measurements")) {
            this.section = 0;
        } else if (qName.equals("group-measurements")) {
            this.section = 1;
        } else if (qName.equals("class-measurements")) {
            this.section = 2;
        } else if (qName.equals("method-measurements")) {
            this.section = 3;
        } else if (qName.equals("measurement")) {
            this.descriptor = new MeasurementDescriptor();
            if (atts.getValue("visible") != null) {
                this.descriptor.setVisible("true".equalsIgnoreCase(atts.getValue("visible")) || "yes".equalsIgnoreCase(atts.getValue("visible")) || "on".equalsIgnoreCase(atts.getValue("visible")));
            }
            if (atts.getValue("cached") != null) {
                this.descriptor.setCached("true".equalsIgnoreCase(atts.getValue("cached")) || "yes".equalsIgnoreCase(atts.getValue("cached")) || "on".equalsIgnoreCase(atts.getValue("cached")));
            }
            switch (this.section) {
                case 0: {
                    this.configuration.addProjectMeasurement(this.descriptor);
                    break;
                }
                case 1: {
                    this.configuration.addGroupMeasurement(this.descriptor);
                    break;
                }
                case 2: {
                    this.configuration.addClassMeasurement(this.descriptor);
                    break;
                }
                case 3: {
                    this.configuration.addMethodMeasurement(this.descriptor);
                }
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals("short-name")) {
            this.descriptor.setShortName(this.currentName.toString().trim());
        } else if (qName.equals("long-name")) {
            this.descriptor.setLongName(this.currentName.toString().trim());
        } else if (qName.equals("class")) {
            try {
                this.descriptor.getClassForByName(this.currentName.toString().trim());
            }
            catch (ClassNotFoundException ex) {
                throw new SAXException("Class not found: " + this.currentName.toString().trim());
            }
        } else if (qName.equals("init")) {
            this.descriptor.setInitText(this.currentName.toString().trim());
        } else if (qName.equals("lower-threshold")) {
            this.descriptor.setLowerThreshold((Comparable)((Object)this.currentName.toString().trim()));
        } else if (qName.equals("upper-threshold")) {
            this.descriptor.setUpperThreshold((Comparable)((Object)this.currentName.toString().trim()));
        } else if (qName.equals("name")) {
            this.name = this.currentName.toString().trim();
        } else if (qName.equals("pattern")) {
            this.pattern = this.currentName.toString().trim();
        } else if (qName.equals("group-definition")) {
            this.configuration.addGroupDefinition(this.name, this.pattern);
        }
        Logger.getLogger(this.getClass()).debug((Object)("endElement qName = " + qName + " (\"" + this.currentName.toString().trim() + "\")"));
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentName.append(ch, start, length);
        Logger.getLogger(this.getClass()).debug((Object)("characters: \"" + new String(ch, start, length) + "\""));
    }
}

