/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;
import projectkyoto.mmd.file.PMDUtil;
import projectkyoto.mmd.file.util2.BufferUtil;

public class PMDBone
implements Serializable {
    private String boneName;
    private int parentBoneIndex;
    private int tailPosBoneIndex;
    private int boneType;
    private int targetBone;
    private Vector3f boneHeadPos;
    private boolean hiza;

    public String toString() {
        return "{boneName = " + this.boneName + " parentBoneIndex = " + this.parentBoneIndex + " tailPosBoneIndex = " + this.tailPosBoneIndex + " boneType = " + this.boneType + " targetBone = " + this.targetBone + " boneHeadPos = {" + (this.boneHeadPos == null ? "null" : "{" + this.boneHeadPos.x + " " + this.boneHeadPos.y + " " + this.boneHeadPos.z) + "}" + "}\n";
    }

    public PMDBone() {
    }

    public PMDBone(DataInputStreamLittleEndian is) throws IOException {
        this.readFromStream(is);
    }

    public PMDBone readFromStream(DataInputStreamLittleEndian is) throws IOException {
        this.boneName = is.readString(20);
        this.parentBoneIndex = is.readUnsignedShort();
        this.tailPosBoneIndex = is.readUnsignedShort();
        this.boneType = is.readByte();
        this.targetBone = is.readShort();
        this.boneHeadPos = new Vector3f(is.readFloat(), is.readFloat(), -is.readFloat());
        this.hiza = this.boneName.indexOf("\u3072\u3056") >= 0;
        return this;
    }

    public void writeToStream(DataOutput os) throws IOException {
        PMDUtil.writeString(os, this.boneName, 20);
        os.writeShort(this.parentBoneIndex);
        os.writeShort(this.tailPosBoneIndex);
        os.writeByte(this.boneType);
        os.writeShort(this.targetBone);
        os.writeFloat(this.boneHeadPos.x);
        os.writeFloat(this.boneHeadPos.y);
        os.writeFloat(-this.boneHeadPos.z);
    }

    public void readFromBuffer(ByteBuffer bb) {
        this.boneName = BufferUtil.readString(bb, 20);
        this.parentBoneIndex = bb.getShort();
        this.tailPosBoneIndex = bb.getShort();
        this.boneType = bb.get();
        this.targetBone = bb.getShort();
        this.boneHeadPos = new Vector3f(bb.getFloat(), bb.getFloat(), bb.getFloat());
        this.hiza = this.boneName.indexOf("\u3072\u3056") >= 0;
    }

    public void writeToBuffer(ByteBuffer bb) {
        BufferUtil.writeString(bb, this.boneName, 20);
        bb.putShort((short)this.parentBoneIndex);
        bb.putShort((short)this.tailPosBoneIndex);
        bb.put((byte)this.boneType);
        bb.putShort((short)this.targetBone);
        bb.putFloat(this.boneHeadPos.x).putFloat(this.boneHeadPos.y).putFloat(this.boneHeadPos.z);
    }

    public Vector3f getBoneHeadPos() {
        return this.boneHeadPos;
    }

    public void setBoneHeadPos(Vector3f boneHeadPos) {
        this.boneHeadPos = boneHeadPos;
    }

    public String getBoneName() {
        return this.boneName;
    }

    public void setBoneName(String boneName) {
        this.boneName = boneName;
    }

    public int getBoneType() {
        return this.boneType;
    }

    public void setBoneType(int boneType) {
        this.boneType = boneType;
    }

    public int getTargetBone() {
        return this.targetBone;
    }

    public void setTargetBone(int targetBone) {
        this.targetBone = targetBone;
    }

    public int getParentBoneIndex() {
        return this.parentBoneIndex;
    }

    public void setParentBoneIndex(int parentBoneIndex) {
        this.parentBoneIndex = parentBoneIndex;
    }

    public int getTailPosBoneIndex() {
        return this.tailPosBoneIndex;
    }

    public void setTailPosBoneIndex(int tailPosBoneIndex) {
        this.tailPosBoneIndex = tailPosBoneIndex;
    }

    public boolean isHiza() {
        return this.hiza;
    }

    public void setHiza(boolean hiza) {
        this.hiza = hiza;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PMDBone other = (PMDBone)obj;
        if (this.boneName == null ? other.boneName != null : !this.boneName.equals(other.boneName)) {
            return false;
        }
        if (this.parentBoneIndex != other.parentBoneIndex) {
            return false;
        }
        if (this.tailPosBoneIndex != other.tailPosBoneIndex) {
            return false;
        }
        if (this.boneType != other.boneType) {
            return false;
        }
        if (this.targetBone != other.targetBone) {
            return false;
        }
        if (!(this.boneHeadPos == other.boneHeadPos || this.boneHeadPos != null && this.boneHeadPos.equals((Tuple3f)other.boneHeadPos))) {
            return false;
        }
        return this.hiza == other.hiza;
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + (this.boneName != null ? this.boneName.hashCode() : 0);
        return hash;
    }
}

