/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.listbox;

import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.ListBoxSelectionChangedEvent;
import de.lessvoid.nifty.controls.listbox.ListBoxFocusItem;
import de.lessvoid.nifty.controls.listbox.ListBoxSelectionMode;
import de.lessvoid.nifty.controls.listbox.ListBoxSelectionModeDisabled;
import de.lessvoid.nifty.controls.listbox.ListBoxSelectionModeMulti;
import de.lessvoid.nifty.controls.listbox.ListBoxSelectionModeSingle;
import de.lessvoid.nifty.controls.listbox.ListBoxView;
import de.lessvoid.nifty.controls.listbox.ListBoxViewNull;
import de.lessvoid.nifty.controls.shared.EmptyNiftyControlImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

public class ListBoxImpl<T>
extends EmptyNiftyControlImpl {
    private ListBox<T> listBox;
    private List<T> items = new ArrayList<T>();
    private List<ItemWidth> widthList = new ArrayList<ItemWidth>();
    private ListBoxSelectionMode<T> selection = new ListBoxSelectionModeSingle();
    private ListBoxView<T> view = new ListBoxViewNull();
    private int viewOffset = 0;
    private int viewDisplayItemCount = 0;
    private int focusItemIndex = -1;
    private List<T> visibleItemsForDisplay = new ArrayList<T>();
    private List<Integer> selectedItemsForDisplay = new ArrayList<Integer>();
    private ListBoxFocusItem listBoxFocusItem = new ListBoxFocusItem();
    private int lastMaxWidth = 0;

    public ListBoxImpl(ListBox<T> listBox) {
        this.listBox = listBox;
    }

    public int bindToView(ListBoxView<T> newListBoxView, int viewDisplayItemCount) {
        this.view = newListBoxView;
        this.viewDisplayItemCount = viewDisplayItemCount;
        return this.items.size();
    }

    public void updateView(int newViewOffset) {
        if (newViewOffset > 0 && newViewOffset >= this.items.size()) {
            return;
        }
        this.viewOffset = newViewOffset;
        this.updateView();
    }

    public void updateView() {
        this.view.display(this.updateCaptions(), this.getFocusItemForDisplay(), this.getSelectionElementsForDisplay());
    }

    public void selectItemByVisualIndex(int selectionIndex) {
        if (this.invalidVisualIndex(selectionIndex)) {
            return;
        }
        this.selectItemByIndex(this.viewOffset + selectionIndex);
    }

    public void deselectItemByVisualIndex(int selectionIndex) {
        if (this.invalidVisualIndex(selectionIndex)) {
            return;
        }
        this.deselectItemByIndex(this.viewOffset + selectionIndex);
    }

    public T getItemByVisualIndex(int selectionIndex) {
        if (this.invalidVisualIndex(selectionIndex)) {
            return null;
        }
        return this.items.get(this.viewOffset + selectionIndex);
    }

    public void changeSelectionMode(ListBox.SelectionMode listBoxSelectionMode, boolean forceSelection) {
        List<T> oldSelection = this.getSelection();
        this.selection = this.createSelectionMode(listBoxSelectionMode);
        this.selection.enableRequiresSelection(forceSelection);
        ListIterator<T> it = oldSelection.listIterator(oldSelection.size());
        while (it.hasPrevious()) {
            this.selection.add(it.previous());
        }
        if (this.selection.requiresAutoSelection() && this.itemCount() > 0) {
            this.selection.add(this.items.get(0));
        }
        this.updateView();
        this.selectionChangedEvent(oldSelection);
    }

    public void addItem(T newItem) {
        this.widthList.add(new ItemWidth(newItem));
        this.items.add(newItem);
        this.widthUpdate();
        this.focusItemIndexUpdate();
        this.updateViewTotalCount();
        this.ensureAutoSelection(newItem);
    }

    public int itemCount() {
        return this.items.size();
    }

    public void clear() {
        List<T> oldSelection = this.getSelection();
        this.items.clear();
        this.selection.clear();
        this.widthList.clear();
        this.lastMaxWidth = 0;
        this.view.updateTotalWidth(this.lastMaxWidth);
        this.focusItemIndexUpdate();
        this.updateViewTotalCount();
        this.selectionChangedEvent(oldSelection);
    }

    public void selectItemByIndex(int selectionIndex) {
        if (this.invalidIndex(selectionIndex)) {
            return;
        }
        List<T> oldSelection = this.getSelection();
        this.selection.add(this.items.get(selectionIndex));
        this.updateView();
        this.selectionChangedEvent(oldSelection);
    }

    public void selectItem(T item) {
        this.selectItemByIndex(this.items.indexOf(item));
    }

    public void selectNext() {
        if (!(this.selection instanceof ListBoxSelectionModeSingle)) {
            return;
        }
        if (this.selection.getSelection().isEmpty()) {
            return;
        }
        int selectionIndex = this.items.indexOf(this.selection.getSelection().get(0));
        if (this.invalidIndex(selectionIndex)) {
            return;
        }
        if (this.invalidIndex(++selectionIndex)) {
            return;
        }
        this.selectItemByIndex(selectionIndex);
        this.setFocusItemByIndex(selectionIndex);
    }

    public void selectPrevious() {
        if (!(this.selection instanceof ListBoxSelectionModeSingle)) {
            return;
        }
        if (this.selection.getSelection().isEmpty()) {
            return;
        }
        int selectionIndex = this.items.indexOf(this.selection.getSelection().get(0));
        if (this.invalidIndex(selectionIndex)) {
            return;
        }
        if (this.invalidIndex(--selectionIndex)) {
            return;
        }
        this.selectItemByIndex(selectionIndex);
        this.setFocusItemByIndex(selectionIndex);
    }

    public List<T> getSelection() {
        return Collections.unmodifiableList(this.selection.getSelection());
    }

    public List<Integer> getSelectedIndices() {
        List<T> sel = this.selection.getSelection();
        if (sel.isEmpty()) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (T selItem : sel) {
            result.add(this.items.indexOf(selItem));
        }
        return result;
    }

    public void removeItemByIndex(int itemIndex) {
        if (this.invalidIndex(itemIndex)) {
            return;
        }
        List<T> oldSelection = this.getSelection();
        int oldCount = this.itemCount();
        T item = this.items.get(itemIndex);
        this.selection.removeForced(item);
        this.items.remove(itemIndex);
        this.widthList.remove(this.findItemIndexInWidthList(item));
        this.widthUpdate();
        this.listBoxFocusItem.prepare();
        this.listBoxFocusItem.registerIndex(itemIndex);
        this.updateAfterRemove(oldSelection, oldCount);
    }

    public void removeItem(T item) {
        this.removeItemByIndex(this.items.indexOf(item));
    }

    public void removeAllItems(List<T> itemsToRemove) {
        List<T> oldSelection = this.getSelection();
        int oldCount = this.itemCount();
        this.listBoxFocusItem.prepare();
        for (T item : itemsToRemove) {
            this.listBoxFocusItem.registerIndex(this.items.indexOf(item));
            this.widthList.remove(this.findItemIndexInWidthList(item));
        }
        this.widthUpdate();
        if (!this.items.removeAll(itemsToRemove)) {
            return;
        }
        for (T item : this.selection.getSelection()) {
            this.selection.removeForced(item);
        }
        this.updateAfterRemove(oldSelection, oldCount);
    }

    public void deselectItemByIndex(int itemIndex) {
        if (this.invalidIndex(itemIndex)) {
            return;
        }
        List<T> oldSelection = this.getSelection();
        this.selection.remove(this.items.get(itemIndex));
        this.updateView();
        this.selectionChangedEvent(oldSelection);
    }

    public void deselectItem(T item) {
        this.deselectItemByIndex(this.items.indexOf(item));
    }

    public List<T> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public void insertItem(T item, int index) {
        if (this.invalidIndexForInsert(index)) {
            return;
        }
        this.widthList.add(new ItemWidth(item));
        this.items.add(index, item);
        this.widthUpdate();
        this.focusItemIndexUpdate();
        this.updateViewTotalCount();
        this.ensureAutoSelection(item);
    }

    public void showItem(T item) {
        this.showItemByIndex(this.items.indexOf(item));
    }

    public void showItemByIndex(int itemIndex) {
        if (this.invalidIndex(itemIndex)) {
            return;
        }
        this.viewOffset = itemIndex;
        if (this.itemCount() <= this.viewDisplayItemCount) {
            this.viewOffset = 0;
        } else if (itemIndex > this.items.size() - this.viewDisplayItemCount) {
            this.viewOffset = this.items.size() - this.viewDisplayItemCount;
        }
        this.view.scrollTo(this.viewOffset);
        this.updateView();
    }

    public void setFocusItem(T item) {
        this.setFocusItemByIndex(this.items.indexOf(item));
    }

    public void setFocusItemByIndex(int itemIndex) {
        if (this.invalidIndex(itemIndex)) {
            return;
        }
        this.focusItemIndex = itemIndex;
        if (this.focusItemIndex >= this.viewOffset + this.viewDisplayItemCount) {
            this.viewOffset = this.focusItemIndex - this.viewDisplayItemCount + 1;
            this.view.scrollTo(this.viewOffset);
            this.updateView();
        } else if (this.focusItemIndex < this.viewOffset) {
            this.showItemByIndex(this.focusItemIndex);
        } else {
            this.updateView();
        }
    }

    public T getFocusItem() {
        if (this.focusItemIndex == -1) {
            return null;
        }
        return this.items.get(this.focusItemIndex);
    }

    public int getFocusItemIndex() {
        return this.focusItemIndex;
    }

    public void setListBoxViewConverter(ListBox.ListBoxViewConverter<T> viewConverter) {
    }

    public void addAllItems(List<T> itemsToAdd) {
        if (itemsToAdd.isEmpty()) {
            return;
        }
        for (T item : itemsToAdd) {
            this.widthList.add(new ItemWidth(item));
        }
        this.items.addAll(itemsToAdd);
        this.widthUpdate();
        this.focusItemIndexUpdate();
        this.updateViewTotalCount();
        this.ensureAutoSelection(itemsToAdd.get(0));
    }

    public void sortItems(Comparator<T> comperator) {
        Collections.sort(this.items, comperator);
    }

    void updateViewTotalCount() {
        this.view.updateTotalCount(this.items.size());
        this.updateView();
    }

    private List<Integer> getSelectionElementsForDisplay() {
        this.selectedItemsForDisplay.clear();
        List<T> selectionList = this.selection.getSelection();
        if (selectionList.isEmpty()) {
            return this.selectedItemsForDisplay;
        }
        for (T selectedItem : selectionList) {
            for (int i = 0; i < this.viewDisplayItemCount; ++i) {
                int selectedItemIndex = this.items.indexOf(selectedItem);
                if (selectedItemIndex != this.viewOffset + i) continue;
                this.selectedItemsForDisplay.add(i);
            }
        }
        return this.selectedItemsForDisplay;
    }

    private List<T> updateCaptions() {
        this.visibleItemsForDisplay.clear();
        for (int i = 0; i < this.viewDisplayItemCount; ++i) {
            Object item = null;
            if (this.viewOffset + i < this.items.size()) {
                item = this.items.get(this.viewOffset + i);
            }
            this.visibleItemsForDisplay.add(item);
        }
        return this.visibleItemsForDisplay;
    }

    private int getFocusItemForDisplay() {
        for (int i = 0; i < this.viewDisplayItemCount; ++i) {
            if (this.viewOffset + i >= this.items.size() || this.focusItemIndex != this.viewOffset + i) continue;
            return i;
        }
        return -1;
    }

    private boolean invalidVisualIndex(int selectionIndex) {
        if (selectionIndex < 0) {
            return true;
        }
        if (selectionIndex >= this.viewDisplayItemCount) {
            return true;
        }
        return selectionIndex >= this.itemCount();
    }

    private boolean invalidIndex(int itemIndex) {
        if (itemIndex < 0) {
            return true;
        }
        return itemIndex >= this.items.size();
    }

    private boolean invalidIndexForInsert(int itemIndex) {
        if (itemIndex < 0) {
            return true;
        }
        return itemIndex > this.items.size();
    }

    private void focusItemIndexUpdate() {
        if (this.items.size() == 0) {
            this.focusItemIndex = -1;
            return;
        }
        if (this.items.size() == 1) {
            this.focusItemIndex = 0;
            return;
        }
        if (this.focusItemIndex == -1 && this.itemCount() > 0) {
            this.focusItemIndex = 0;
        }
    }

    private void selectionChangedEvent(List<T> oldSelection) {
        this.view.publish(new ListBoxSelectionChangedEvent<T>(this.listBox, this.getSelection(), this.getSelectedIndices()));
    }

    private void updateAfterRemove(List<T> oldSelection, int oldItemCount) {
        this.focusItemIndex = this.listBoxFocusItem.resolve(this.focusItemIndex, oldItemCount);
        this.focusItemIndexUpdate();
        if (this.selection.requiresAutoSelection() && this.itemCount() > 0 && this.focusItemIndex > -1) {
            this.selection.add(this.items.get(this.focusItemIndex));
        }
        this.view.updateTotalCount(this.items.size());
        if (this.viewOffset + this.viewDisplayItemCount > this.itemCount() && this.itemCount() > 0) {
            this.showItemByIndex(this.itemCount() - 1);
            this.selectionChangedEvent(oldSelection);
            return;
        }
        this.updateView();
        this.selectionChangedEvent(oldSelection);
    }

    private void widthUpdate() {
        if (this.widthList.isEmpty()) {
            if (this.lastMaxWidth != 0) {
                this.lastMaxWidth = 0;
                this.view.updateTotalWidth(0);
            }
            return;
        }
        Collections.sort(this.widthList);
        if (this.widthList.get(this.widthList.size() - 1).getWidth() != this.lastMaxWidth) {
            this.lastMaxWidth = this.widthList.get(this.widthList.size() - 1).getWidth();
            this.view.updateTotalWidth(this.lastMaxWidth);
        }
    }

    private int findItemIndexInWidthList(T item) {
        for (int i = 0; i < this.widthList.size(); ++i) {
            ItemWidth itemWidth = this.widthList.get(i);
            if (!itemWidth.getItem().equals(item)) continue;
            return i;
        }
        return -1;
    }

    private void ensureAutoSelection(T newItem) {
        if (this.selection.requiresAutoSelection()) {
            this.selectItem(newItem);
        }
    }

    private ListBoxSelectionMode<T> createSelectionMode(ListBox.SelectionMode selectionMode) {
        switch (selectionMode) {
            case Single: {
                return new ListBoxSelectionModeSingle();
            }
            case Multiple: {
                return new ListBoxSelectionModeMulti();
            }
            case Disabled: {
                return new ListBoxSelectionModeDisabled();
            }
        }
        return new ListBoxSelectionModeSingle();
    }

    public class ItemWidth
    implements Comparable<ItemWidth> {
        private T item;
        private int width;

        public ItemWidth(T item) {
            this.item = item;
            this.width = ListBoxImpl.this.view.getWidth(item);
        }

        @Override
        public int compareTo(ItemWidth a) {
            return Integer.valueOf(this.width).compareTo(a.width);
        }

        public boolean equals(Object obj) {
            return this.item.equals(obj);
        }

        public int hashCode() {
            return this.item.hashCode();
        }

        public T getItem() {
            return this.item;
        }

        public int getWidth() {
            return this.width;
        }
    }
}

