/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.ConstantPool;
import com.jeantessier.classreader.impl.ElementValue;
import com.jeantessier.classreader.impl.ElementValueFactory;
import com.jeantessier.classreader.impl.ElementValueType;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class ArrayElementValue
extends ElementValue
implements com.jeantessier.classreader.ArrayElementValue {
    private Collection<ElementValue> values = new ArrayList<ElementValue>();

    public ArrayElementValue(ConstantPool constantPool, DataInput in) throws IOException {
        this(constantPool, in, new ElementValueFactory());
    }

    public ArrayElementValue(ConstantPool constantPool, DataInput in, ElementValueFactory elementValueFactory) throws IOException {
        super(constantPool);
        int numValues = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + numValues + " value(s) ..."));
        for (int i = 0; i < numValues; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("value " + i + ":"));
            this.values.add(elementValueFactory.create(constantPool, in));
        }
    }

    public Collection<? extends ElementValue> getValues() {
        return this.values;
    }

    @Override
    public char getTag() {
        return ElementValueType.ARRAY.getTag();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitArrayElementValue(this);
    }
}

