/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.ConstantPoolEntry;
import com.jeantessier.classreader.TextPrinter;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.Class_info;
import com.jeantessier.classreader.impl.Classfile;
import com.jeantessier.classreader.impl.Double_info;
import com.jeantessier.classreader.impl.FieldRef_info;
import com.jeantessier.classreader.impl.Float_info;
import com.jeantessier.classreader.impl.Integer_info;
import com.jeantessier.classreader.impl.InterfaceMethodRef_info;
import com.jeantessier.classreader.impl.Long_info;
import com.jeantessier.classreader.impl.MethodRef_info;
import com.jeantessier.classreader.impl.NameAndType_info;
import com.jeantessier.classreader.impl.String_info;
import com.jeantessier.classreader.impl.UTF8_info;
import java.io.DataInput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ConstantPool
extends ArrayList<ConstantPoolEntry>
implements com.jeantessier.classreader.ConstantPool {
    private Classfile classfile;

    public ConstantPool(Classfile classfile, DataInput in) throws IOException {
        this.classfile = classfile;
        int count = in.readUnsignedShort();
        this.ensureCapacity(count);
        this.add(null);
        block13: for (int i = 1; i < count; ++i) {
            byte tag = in.readByte();
            switch (tag) {
                case 7: {
                    this.add(new Class_info(this, in));
                    continue block13;
                }
                case 9: {
                    this.add(new FieldRef_info(this, in));
                    continue block13;
                }
                case 10: {
                    this.add(new MethodRef_info(this, in));
                    continue block13;
                }
                case 11: {
                    this.add(new InterfaceMethodRef_info(this, in));
                    continue block13;
                }
                case 8: {
                    this.add(new String_info(this, in));
                    continue block13;
                }
                case 3: {
                    this.add(new Integer_info(this, in));
                    continue block13;
                }
                case 4: {
                    this.add(new Float_info(this, in));
                    continue block13;
                }
                case 5: {
                    this.add(new Long_info(this, in));
                    ++i;
                    this.add(null);
                    continue block13;
                }
                case 6: {
                    this.add(new Double_info(this, in));
                    ++i;
                    this.add(null);
                    continue block13;
                }
                case 12: {
                    this.add(new NameAndType_info(this, in));
                    continue block13;
                }
                case 1: {
                    this.add(new UTF8_info(this, in));
                    continue block13;
                }
                default: {
                    Logger.getLogger(this.getClass()).info((Object)("Unknown Tag " + tag));
                }
            }
        }
    }

    public Classfile getClassfile() {
        return this.classfile;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantPool(this);
    }

    @Override
    public String toString() {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        writer.println("Constant Pool:");
        TextPrinter printer = new TextPrinter(writer);
        this.accept(printer);
        writer.close();
        return out.toString();
    }
}

