/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.UTF8_info;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.ConstantPool;
import com.jeantessier.classreader.impl.ElementValue;
import com.jeantessier.classreader.impl.ElementValueFactory;
import java.io.DataInput;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ElementValuePair
implements com.jeantessier.classreader.ElementValuePair {
    private ConstantPool constantPool;
    private int elementNameIndex;
    private ElementValue elementValue;

    public ElementValuePair(ConstantPool constantPool, DataInput in) throws IOException {
        this(constantPool, in, new ElementValueFactory());
    }

    public ElementValuePair(ConstantPool constantPool, DataInput in, ElementValueFactory elementValueFactory) throws IOException {
        this.constantPool = constantPool;
        this.elementNameIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Element name index: " + this.elementNameIndex + " (" + this.getElementName() + ")"));
        this.elementValue = elementValueFactory.create(constantPool, in);
    }

    @Override
    public int getElementNameIndex() {
        return this.elementNameIndex;
    }

    @Override
    public UTF8_info getRawElementName() {
        return (UTF8_info)this.constantPool.get(this.getElementNameIndex());
    }

    @Override
    public String getElementName() {
        return this.getRawElementName().getValue();
    }

    @Override
    public ElementValue getElementValue() {
        return this.elementValue;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitElementValuePair(this);
    }
}

