/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.AttributeType;
import com.jeantessier.classreader.impl.Attribute_info;
import com.jeantessier.classreader.impl.ConstantPool;
import com.jeantessier.classreader.impl.LocalVariable;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class LocalVariableTable_attribute
extends Attribute_info
implements com.jeantessier.classreader.LocalVariableTable_attribute {
    private Collection<LocalVariable> localVariables = new LinkedList<LocalVariable>();

    public LocalVariableTable_attribute(ConstantPool constantPool, Visitable owner, DataInput in) throws IOException {
        super(constantPool, owner);
        int byteCount = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("Attribute length: " + byteCount));
        int localVariableTableLength = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + localVariableTableLength + " local variable(s) ..."));
        for (int i = 0; i < localVariableTableLength; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("Local variable " + i + ":"));
            this.localVariables.add(new LocalVariable(this, in));
        }
    }

    public Collection<LocalVariable> getLocalVariables() {
        return this.localVariables;
    }

    public String toString() {
        return "Local Variable Table";
    }

    @Override
    public String getAttributeName() {
        return AttributeType.LOCAL_VARIABLE_TABLE.getAttributeName();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLocalVariableTable_attribute(this);
    }
}

