/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.Visitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public abstract class Node
implements Comparable {
    private String name = "";
    private boolean confirmed = false;
    private Collection<Node> inbound = new HashSet<Node>();
    private Collection<Node> outbound = new HashSet<Node>();

    public Node(String name, boolean confirmed) {
        this.name = name;
        this.confirmed = confirmed;
    }

    public String getName() {
        return this.name;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public boolean canAddDependencyTo(Node node) {
        return !this.equals(node);
    }

    public void addDependency(Node node) {
        if (this.canAddDependencyTo(node) && node.canAddDependencyTo(this)) {
            this.outbound.add(node);
            node.inbound.add(this);
        }
    }

    public void addDependencies(Collection<Node> nodes) {
        for (Node node : nodes) {
            this.addDependency(node);
        }
    }

    public void removeDependency(Node node) {
        this.outbound.remove(node);
        node.inbound.remove(this);
    }

    public void removeDependencies(Collection<? extends Node> nodes) {
        for (Node node : nodes) {
            this.removeDependency(node);
        }
    }

    public Collection<Node> getInboundDependencies() {
        return Collections.unmodifiableCollection(this.inbound);
    }

    public Collection<Node> getOutboundDependencies() {
        return Collections.unmodifiableCollection(this.outbound);
    }

    public abstract void accept(Visitor var1);

    public abstract void acceptInbound(Visitor var1);

    public abstract void acceptOutbound(Visitor var1);

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        Node other;
        boolean result = this == object ? true : (object == null || this.getClass() != object.getClass() ? false : this.compareTo(other = (Node)object) == 0);
        return result;
    }

    public int compareTo(Object object) {
        int result;
        if (this == object) {
            result = 0;
        } else {
            if (object == null) {
                throw new ClassCastException("compareTo: expected a " + this.getClass().getName() + " but got null");
            }
            if (!(object instanceof Node)) {
                throw new ClassCastException("compareTo: expected a " + this.getClass().getName() + " but got a " + object.getClass().getName());
            }
            Node other = (Node)object;
            result = this.getName().compareTo(other.getName());
        }
        return result;
    }

    public String toString() {
        return this.getName();
    }
}

