/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.ant;

import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.DefaultSymbolGathererStrategy;
import com.jeantessier.classreader.FilteringSymbolGathererStrategy;
import com.jeantessier.classreader.FinalMethodOrClassSymbolGathererStrategy;
import com.jeantessier.classreader.LoadListenerVisitorAdapter;
import com.jeantessier.classreader.NonPrivateFieldSymbolGathererStrategy;
import com.jeantessier.classreader.SymbolGatherer;
import com.jeantessier.classreader.SymbolGathererStrategy;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.dependencyfinder.ant.VerboseListener;
import com.jeantessier.text.RegularExpressionParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class ListSymbols
extends Task {
    private boolean classNames = false;
    private boolean fieldNames = false;
    private boolean methodNames = false;
    private boolean localNames = false;
    private boolean nonPrivateFieldNames = false;
    private boolean finalMethodOrClassNames = false;
    private List<String> includes = Collections.singletonList("//");
    private List<String> excludes = Collections.emptyList();
    private File destfile;
    private Path path;

    public boolean getClassnames() {
        return this.classNames;
    }

    public void setClassnames(boolean classNames) {
        this.classNames = classNames;
    }

    public boolean getFieldnames() {
        return this.fieldNames;
    }

    public void setFieldnames(boolean fieldNames) {
        this.fieldNames = fieldNames;
    }

    public boolean getMethodnames() {
        return this.methodNames;
    }

    public void setMethodnames(boolean methodNames) {
        this.methodNames = methodNames;
    }

    public boolean getLocalnames() {
        return this.localNames;
    }

    public void setLocalnames(boolean localNames) {
        this.localNames = localNames;
    }

    public boolean getNonprivatefieldnames() {
        return this.nonPrivateFieldNames;
    }

    public void setNonprivatefieldnames(boolean nonPrivateFieldNames) {
        this.nonPrivateFieldNames = nonPrivateFieldNames;
    }

    public boolean getFinalmethodorclassnames() {
        return this.finalMethodOrClassNames;
    }

    public void setFinalmethodorclassnames(boolean finalMethodOrClassNames) {
        this.finalMethodOrClassNames = finalMethodOrClassNames;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = RegularExpressionParser.parseRE(includes);
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = RegularExpressionParser.parseRE(excludes);
    }

    public File getDestfile() {
        return this.destfile;
    }

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public Path createPath() {
        if (this.path == null) {
            this.path = new Path(this.getProject());
        }
        return this.path;
    }

    public Path getPath() {
        return this.path;
    }

    void validateParameters() throws BuildException {
        if (this.getPath() == null) {
            throw new BuildException("path must be set!");
        }
        if (this.getDestfile() == null) {
            throw new BuildException("destfile must be set!");
        }
    }

    public void execute() throws BuildException {
        this.validateParameters();
        this.log("Reading classes from path " + this.getPath());
        VerboseListener verboseListener = new VerboseListener(this);
        SymbolGatherer gatherer = new SymbolGatherer(this.createStrategy());
        TransientClassfileLoader loader = new TransientClassfileLoader();
        ((ClassfileLoader)loader).addLoadListener(new LoadListenerVisitorAdapter(gatherer));
        ((ClassfileLoader)loader).addLoadListener(verboseListener);
        loader.load(Arrays.asList(this.getPath().list()));
        this.log("Saving symbols to " + this.getDestfile().getAbsolutePath());
        try {
            PrintWriter out = new PrintWriter(new FileWriter(this.getDestfile()));
            for (String symbol : gatherer.getCollection()) {
                out.println(symbol);
            }
            out.close();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    SymbolGathererStrategy createStrategy() {
        SymbolGathererStrategy result = this.getNonprivatefieldnames() ? new NonPrivateFieldSymbolGathererStrategy() : (this.getFinalmethodorclassnames() ? new FinalMethodOrClassSymbolGathererStrategy() : this.createDefaultSymbolGathererStrategy());
        result = new FilteringSymbolGathererStrategy(result, this.getIncludes(), this.getExcludes());
        return result;
    }

    private SymbolGathererStrategy createDefaultSymbolGathererStrategy() {
        DefaultSymbolGathererStrategy result = new DefaultSymbolGathererStrategy();
        if (this.getClassnames() || this.getFieldnames() || this.getMethodnames() || this.getLocalnames()) {
            result.setMatchingClassNames(false);
            result.setMatchingFieldNames(false);
            result.setMatchingMethodNames(false);
            result.setMatchingLocalNames(false);
        }
        if (this.getClassnames()) {
            result.setMatchingClassNames(true);
        }
        if (this.getFieldnames()) {
            result.setMatchingFieldNames(true);
        }
        if (this.getMethodnames()) {
            result.setMatchingMethodNames(true);
        }
        if (this.getLocalnames()) {
            result.setMatchingLocalNames(true);
        }
        return result;
    }
}

