/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.gui;

import com.jeantessier.dependency.MatchException;
import com.jeantessier.dependencyfinder.gui.DependencyFinder;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class MetricsQueryAction
extends AbstractAction
implements Runnable {
    private DependencyFinder model = null;

    public MetricsQueryAction(DependencyFinder model) {
        this.model = model;
        this.putValue("LongDescription", "Compute dependency metrics");
        this.putValue("Name", "Metrics");
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("icons/metrics-query.gif")));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new Thread(this).start();
    }

    @Override
    public void run() {
        try {
            this.model.getStatusLine().showInfo("Processing metrics query ...");
            Date start = new Date();
            this.model.clearMetricsResult();
            this.model.doMetricsQuery();
            Date stop = new Date();
            this.model.getStatusLine().showInfo("Metrics query done (" + (double)(stop.getTime() - start.getTime()) / 1000.0 + " secs).");
        }
        catch (MatchException ex) {
            JOptionPane.showMessageDialog(this.model, ex.getMessage() + ": " + ex.getCause().getMessage(), "Malformed pattern", 0);
            this.model.getStatusLine().showInfo("Ready.");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.model, ex.getMessage(), "Error", 0);
            this.model.getStatusLine().showInfo("Ready.");
        }
    }
}

