/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.font.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.font.BitmapCharacter;
import com.jme3.font.BitmapCharacterSet;
import com.jme3.font.BitmapFont;
import com.jme3.material.Material;
import com.jme3.material.MaterialDef;
import com.jme3.material.RenderState;
import com.jme3.texture.Texture;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class BitmapFontLoader
implements AssetLoader {
    private BitmapFont load(AssetManager assetManager, String folder, InputStream in) throws IOException {
        MaterialDef spriteMat = (MaterialDef)assetManager.loadAsset(new AssetKey("Common/MatDefs/Misc/Unshaded.j3md"));
        BitmapCharacterSet charSet = new BitmapCharacterSet();
        Material[] matPages = null;
        BitmapFont font = new BitmapFont();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String regex = "[\\s=]+";
        font.setCharSet(charSet);
        while (reader.ready()) {
            String line = reader.readLine();
            String[] tokens = line.split(regex);
            if (tokens[0].equals("info")) {
                for (int i = 1; i < tokens.length; ++i) {
                    if (!tokens[i].equals("size")) continue;
                    charSet.setRenderedSize(Integer.parseInt(tokens[i + 1]));
                }
                continue;
            }
            if (tokens[0].equals("common")) {
                for (int i = 1; i < tokens.length; ++i) {
                    String token = tokens[i];
                    if (token.equals("lineHeight")) {
                        charSet.setLineHeight(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (token.equals("base")) {
                        charSet.setBase(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (token.equals("scaleW")) {
                        charSet.setWidth(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (token.equals("scaleH")) {
                        charSet.setHeight(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (!token.equals("pages")) continue;
                    matPages = new Material[Integer.parseInt(tokens[i + 1])];
                    font.setPages(matPages);
                }
                continue;
            }
            if (tokens[0].equals("page")) {
                int index = -1;
                Texture tex = null;
                for (int i = 1; i < tokens.length; ++i) {
                    String token = tokens[i];
                    if (token.equals("id")) {
                        index = Integer.parseInt(tokens[i + 1]);
                        continue;
                    }
                    if (!token.equals("file")) continue;
                    String file = tokens[i + 1];
                    if (file.startsWith("\"")) {
                        file = file.substring(1, file.length() - 1);
                    }
                    TextureKey key = new TextureKey(folder + file, true);
                    key.setGenerateMips(false);
                    tex = assetManager.loadTexture(key);
                    tex.setMagFilter(Texture.MagFilter.Bilinear);
                    tex.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
                }
                if (index < 0 || tex == null) continue;
                Material mat = new Material(spriteMat);
                mat.setTexture("ColorMap", tex);
                mat.setBoolean("VertexColor", true);
                mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
                matPages[index] = mat;
                continue;
            }
            if (tokens[0].equals("char")) {
                BitmapCharacter ch = null;
                for (int i = 1; i < tokens.length; ++i) {
                    String token = tokens[i];
                    if (token.equals("id")) {
                        int index = Integer.parseInt(tokens[i + 1]);
                        ch = new BitmapCharacter();
                        charSet.addCharacter(index, ch);
                        continue;
                    }
                    if (token.equals("x")) {
                        ch.setX(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (token.equals("y")) {
                        ch.setY(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (token.equals("width")) {
                        ch.setWidth(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (token.equals("height")) {
                        ch.setHeight(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (token.equals("xoffset")) {
                        ch.setXOffset(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (token.equals("yoffset")) {
                        ch.setYOffset(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (token.equals("xadvance")) {
                        ch.setXAdvance(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (!token.equals("page")) continue;
                    ch.setPage(Integer.parseInt(tokens[i + 1]));
                }
                continue;
            }
            if (!tokens[0].equals("kerning")) continue;
            int index = 0;
            int second = 0;
            int amount = 0;
            for (int i = 1; i < tokens.length; ++i) {
                if (tokens[i].equals("first")) {
                    index = Integer.parseInt(tokens[i + 1]);
                    continue;
                }
                if (tokens[i].equals("second")) {
                    second = Integer.parseInt(tokens[i + 1]);
                    continue;
                }
                if (!tokens[i].equals("amount")) continue;
                amount = Integer.parseInt(tokens[i + 1]);
            }
            BitmapCharacter ch = charSet.getCharacter(index);
            ch.addKerning(second, amount);
        }
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(AssetInfo info) throws IOException {
        InputStream in = null;
        try {
            BitmapFont font;
            in = info.openStream();
            BitmapFont bitmapFont = font = this.load(info.getManager(), info.getKey().getFolder(), in);
            return bitmapFont;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

