/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.lwjgl;

import com.jme3.input.InputManager;
import com.jme3.input.JoyInput;
import com.jme3.input.Joystick;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.JoyAxisEvent;
import com.jme3.input.event.JoyButtonEvent;
import com.jme3.util.IntMap;
import java.util.HashMap;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;
import net.java.games.input.Rumbler;

public class JInputJoyInput
implements JoyInput {
    private boolean inited = false;
    private Joystick[] joysticks;
    private RawInputListener listener;
    private HashMap<Component.Identifier.Button, Integer>[] buttonIdsToIndices;
    private HashMap<Component.Identifier.Axis, Integer>[] axisIdsToIndices;
    private HashMap<Controller, Integer> controllerToIndices;
    private IntMap<Controller> indicesToController;
    private int xAxis;
    private int yAxis;

    private void loadIdentifiers(int controllerIdx, Controller c) {
        Component[] ces = c.getComponents();
        int numButtons = 0;
        int numAxes = 0;
        this.xAxis = -1;
        this.yAxis = -1;
        for (Component comp : ces) {
            Component.Identifier id = comp.getIdentifier();
            if (id instanceof Component.Identifier.Button) {
                this.buttonIdsToIndices[controllerIdx].put((Component.Identifier.Button)id, numButtons);
                ++numButtons;
                continue;
            }
            if (!(id instanceof Component.Identifier.Axis)) continue;
            Component.Identifier.Axis axis = (Component.Identifier.Axis)id;
            if (axis == Component.Identifier.Axis.X) {
                this.xAxis = numAxes;
            } else if (axis == Component.Identifier.Axis.Y) {
                this.yAxis = numAxes;
            }
            this.axisIdsToIndices[controllerIdx].put((Component.Identifier.Axis)id, numAxes);
            ++numAxes;
        }
    }

    public void setJoyRumble(int joyId, float amount) {
        Controller c = this.indicesToController.get(joyId);
        if (c == null) {
            throw new IllegalArgumentException();
        }
        for (Rumbler r : c.getRumblers()) {
            r.rumble(amount);
        }
    }

    public Joystick[] loadJoysticks(InputManager inputManager) {
        Controller c;
        int i;
        ControllerEnvironment ce = ControllerEnvironment.getDefaultEnvironment();
        int joyIndex = 0;
        this.controllerToIndices = new HashMap();
        this.indicesToController = new IntMap();
        Controller[] cs = ce.getControllers();
        for (i = 0; i < cs.length; ++i) {
            c = cs[i];
            if (c.getType() == Controller.Type.UNKNOWN || c.getType() == Controller.Type.KEYBOARD || c.getType() == Controller.Type.MOUSE) continue;
            this.controllerToIndices.put(c, joyIndex);
            this.indicesToController.put(joyIndex, c);
            ++joyIndex;
        }
        this.buttonIdsToIndices = new HashMap[joyIndex];
        this.axisIdsToIndices = new HashMap[joyIndex];
        this.joysticks = new Joystick[joyIndex];
        joyIndex = 0;
        for (i = 0; i < cs.length; ++i) {
            Joystick joy;
            c = cs[i];
            if (c.getType() == Controller.Type.UNKNOWN || c.getType() == Controller.Type.KEYBOARD || c.getType() == Controller.Type.MOUSE) continue;
            this.buttonIdsToIndices[joyIndex] = new HashMap();
            this.axisIdsToIndices[joyIndex] = new HashMap();
            this.loadIdentifiers(joyIndex, c);
            this.joysticks[joyIndex] = joy = new Joystick(inputManager, this, joyIndex, c.getName(), this.buttonIdsToIndices[joyIndex].size(), this.axisIdsToIndices[joyIndex].size(), this.xAxis, this.yAxis);
            ++joyIndex;
        }
        return this.joysticks;
    }

    public void initialize() {
        this.inited = true;
    }

    public void update() {
        ControllerEnvironment ce = ControllerEnvironment.getDefaultEnvironment();
        Controller[] cs = ce.getControllers();
        Event e = new Event();
        for (int i = 0; i < cs.length; ++i) {
            Controller c = cs[i];
            if (c.getType() == Controller.Type.UNKNOWN || c.getType() == Controller.Type.KEYBOARD || c.getType() == Controller.Type.MOUSE || !c.poll()) continue;
            int joyId = this.controllerToIndices.get(c);
            EventQueue q = c.getEventQueue();
            while (q.getNextEvent(e)) {
                Component.Identifier id = e.getComponent().getIdentifier();
                if (id == Component.Identifier.Axis.POV) {
                    float x = 0.0f;
                    float y = 0.0f;
                    float v = e.getValue();
                    if (v == 0.0f) {
                        x = 0.0f;
                        y = 0.0f;
                    } else if (v == 0.75f) {
                        x = 0.0f;
                        y = -1.0f;
                    } else if (v == 0.875f) {
                        x = -1.0f;
                        y = -1.0f;
                    } else if (v == 0.625f) {
                        x = -1.0f;
                        y = 1.0f;
                    } else if (v == 1.0f) {
                        x = -1.0f;
                        y = 0.0f;
                    } else if (v == 0.5f) {
                        x = 1.0f;
                        y = 0.0f;
                    } else if (v == 0.25f) {
                        x = 0.0f;
                        y = 1.0f;
                    } else if (v == 0.125f) {
                        x = -1.0f;
                        y = 1.0f;
                    } else if (v == 0.375f) {
                        x = 1.0f;
                        y = 1.0f;
                    }
                    JoyAxisEvent evt1 = new JoyAxisEvent(joyId, 254, x);
                    JoyAxisEvent evt2 = new JoyAxisEvent(joyId, 255, y);
                    this.listener.onJoyAxisEvent(evt1);
                    this.listener.onJoyAxisEvent(evt2);
                    continue;
                }
                if (id instanceof Component.Identifier.Axis) {
                    float value = e.getValue();
                    Component.Identifier.Axis axis = (Component.Identifier.Axis)id;
                    JoyAxisEvent evt = new JoyAxisEvent(joyId, this.axisIdsToIndices[joyId].get(axis), value);
                    this.listener.onJoyAxisEvent(evt);
                    continue;
                }
                if (!(id instanceof Component.Identifier.Button)) continue;
                Component.Identifier.Button button = (Component.Identifier.Button)id;
                JoyButtonEvent evt = new JoyButtonEvent(joyId, this.buttonIdsToIndices[joyId].get(button), e.getValue() == 1.0f);
                this.listener.onJoyButtonEvent(evt);
            }
        }
    }

    public void destroy() {
        this.inited = false;
    }

    public boolean isInitialized() {
        return this.inited;
    }

    public void setInputListener(RawInputListener listener) {
        this.listener = listener;
    }

    public long getInputTimeNanos() {
        return 0L;
    }
}

