/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.texture.Texture;
import java.util.logging.Logger;

abstract class TextureGenerator {
    private static final Logger LOGGER = Logger.getLogger(TextureGenerator.class.getName());
    protected NoiseGenerator noiseGenerator;

    public TextureGenerator(NoiseGenerator noiseGenerator) {
        this.noiseGenerator = noiseGenerator;
    }

    protected abstract Texture generate(Structure var1, int var2, int var3, int var4, DataRepository var5);

    protected TextureHelper.ColorBand readColorband(Structure tex, DataRepository dataRepository) {
        TextureHelper.ColorBand result = null;
        int flag = ((Number)tex.getFieldValue("flag")).intValue();
        if ((flag & 1) != 0) {
            Pointer pColorband = (Pointer)tex.getFieldValue("coba");
            try {
                Structure colorbandStructure = pColorband.fetchData(dataRepository.getInputStream()).get(0);
                result = new TextureHelper.ColorBand(colorbandStructure);
            }
            catch (BlenderFileException e) {
                LOGGER.warning("Cannot fetch the colorband structure. The reason: " + e.getLocalizedMessage());
            }
        }
        return result;
    }
}

