/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.BlenderKey;
import com.jme3.asset.GeneratedTextureKey;
import com.jme3.asset.TextureKey;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.textures.ImageLoader;
import com.jme3.scene.plugins.blender.textures.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorBlend;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorClouds;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorDistnoise;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorMagic;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorMarble;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorMusgrave;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorNoise;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorStucci;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorVoronoi;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorWood;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.Texture3D;
import com.jme3.util.BufferUtils;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3tools.converters.ImageToAwt;

public class TextureHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(TextureHelper.class.getName());
    public static final int TEX_NONE = 0;
    public static final int TEX_CLOUDS = 1;
    public static final int TEX_WOOD = 2;
    public static final int TEX_MARBLE = 3;
    public static final int TEX_MAGIC = 4;
    public static final int TEX_BLEND = 5;
    public static final int TEX_STUCCI = 6;
    public static final int TEX_NOISE = 7;
    public static final int TEX_IMAGE = 8;
    public static final int TEX_PLUGIN = 9;
    public static final int TEX_ENVMAP = 10;
    public static final int TEX_MUSGRAVE = 11;
    public static final int TEX_VORONOI = 12;
    public static final int TEX_DISTNOISE = 13;
    public static final int TEX_POINTDENSITY = 14;
    public static final int TEX_VOXELDATA = 15;
    public static final int MAP_COL = 1;
    public static final int MAP_NORM = 2;
    public static final int MAP_COLSPEC = 4;
    public static final int MAP_COLMIR = 8;
    public static final int MAP_VARS = 65520;
    public static final int MAP_REF = 16;
    public static final int MAP_SPEC = 32;
    public static final int MAP_EMIT = 64;
    public static final int MAP_ALPHA = 128;
    public static final int MAP_HAR = 256;
    public static final int MAP_RAYMIRR = 512;
    public static final int MAP_TRANSLU = 1024;
    public static final int MAP_AMB = 2048;
    public static final int MAP_DISPLACE = 4096;
    public static final int MAP_WARP = 8192;
    public static final int MAP_LAYER = 16384;
    public static final int MTEX_BLEND = 0;
    public static final int MTEX_MUL = 1;
    public static final int MTEX_ADD = 2;
    public static final int MTEX_SUB = 3;
    public static final int MTEX_DIV = 4;
    public static final int MTEX_DARK = 5;
    public static final int MTEX_DIFF = 6;
    public static final int MTEX_LIGHT = 7;
    public static final int MTEX_SCREEN = 8;
    public static final int MTEX_OVERLAY = 9;
    public static final int MTEX_BLEND_HUE = 10;
    public static final int MTEX_BLEND_SAT = 11;
    public static final int MTEX_BLEND_VAL = 12;
    public static final int MTEX_BLEND_COLOR = 13;
    public static final int MTEX_NUM_BLENDTYPES = 14;
    public static final int MA_RAMP_BLEND = 0;
    public static final int MA_RAMP_ADD = 1;
    public static final int MA_RAMP_MULT = 2;
    public static final int MA_RAMP_SUB = 3;
    public static final int MA_RAMP_SCREEN = 4;
    public static final int MA_RAMP_DIV = 5;
    public static final int MA_RAMP_DIFF = 6;
    public static final int MA_RAMP_DARK = 7;
    public static final int MA_RAMP_LIGHT = 8;
    public static final int MA_RAMP_OVERLAY = 9;
    public static final int MA_RAMP_DODGE = 10;
    public static final int MA_RAMP_BURN = 11;
    public static final int MA_RAMP_HUE = 12;
    public static final int MA_RAMP_SAT = 13;
    public static final int MA_RAMP_VAL = 14;
    public static final int MA_RAMP_COLOR = 15;
    protected NoiseGenerator noiseGenerator;
    private Map<Integer, TextureGenerator> textureGenerators = new HashMap<Integer, TextureGenerator>();

    public TextureHelper(String blenderVersion) {
        super(blenderVersion);
        this.noiseGenerator = new NoiseGenerator(blenderVersion);
        this.textureGenerators.put(5, new TextureGeneratorBlend(this.noiseGenerator));
        this.textureGenerators.put(1, new TextureGeneratorClouds(this.noiseGenerator));
        this.textureGenerators.put(13, new TextureGeneratorDistnoise(this.noiseGenerator));
        this.textureGenerators.put(4, new TextureGeneratorMagic(this.noiseGenerator));
        this.textureGenerators.put(3, new TextureGeneratorMarble(this.noiseGenerator));
        this.textureGenerators.put(11, new TextureGeneratorMusgrave(this.noiseGenerator));
        this.textureGenerators.put(7, new TextureGeneratorNoise(this.noiseGenerator));
        this.textureGenerators.put(6, new TextureGeneratorStucci(this.noiseGenerator));
        this.textureGenerators.put(12, new TextureGeneratorVoronoi(this.noiseGenerator));
        this.textureGenerators.put(2, new TextureGeneratorWood(this.noiseGenerator));
    }

    public Texture getTexture(Structure tex, DataRepository dataRepository) throws BlenderFileException {
        Texture result = (Texture)dataRepository.getLoadedFeature(tex.getOldMemoryAddress(), DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
        if (result != null) {
            return result;
        }
        int type = ((Number)tex.getFieldValue("type")).intValue();
        int width = dataRepository.getBlenderKey().getGeneratedTextureWidth();
        int height = dataRepository.getBlenderKey().getGeneratedTextureHeight();
        int depth = dataRepository.getBlenderKey().getGeneratedTextureDepth();
        switch (type) {
            case 8: {
                Pointer pImage = (Pointer)tex.getFieldValue("ima");
                if (!pImage.isNotNull()) break;
                Structure image = pImage.fetchData(dataRepository.getInputStream()).get(0);
                result = this.getTextureFromImage(image, dataRepository);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                TextureGenerator textureGenerator = this.textureGenerators.get(type);
                result = textureGenerator.generate(tex, width, height, depth, dataRepository);
                break;
            }
            case 0: {
                break;
            }
            case 14: {
                LOGGER.warning("Point density texture loading currently not supported!");
                break;
            }
            case 15: {
                LOGGER.warning("Voxel data texture loading currently not supported!");
                break;
            }
            case 9: 
            case 10: {
                LOGGER.log(Level.WARNING, "Unsupported texture type: {0} for texture: {1}", new Object[]{type, tex.getName()});
                break;
            }
            default: {
                throw new BlenderFileException("Unknown texture type: " + type + " for texture: " + tex.getName());
            }
        }
        if (result != null) {
            result.setName(tex.getName());
            result.setWrap(Texture.WrapMode.Repeat);
            if (type != 8) {
                result.setKey(new GeneratedTextureKey(tex.getName()));
            }
        }
        return result;
    }

    public Texture blendTexture(float[] materialColor, Texture texture, float[] color, float affectFactor, int blendType, boolean neg, DataRepository dataRepository) {
        float[] materialColorClone = (float[])materialColor.clone();
        Image.Format format = texture.getImage().getFormat();
        ByteBuffer data = texture.getImage().getData(0);
        data.rewind();
        int width = texture.getImage().getWidth();
        int height = texture.getImage().getHeight();
        int depth = texture.getImage().getDepth();
        if (depth == 0) {
            depth = 1;
        }
        ByteBuffer newData = BufferUtils.createByteBuffer(width * height * depth * 4);
        float[] resultPixel = new float[4];
        int dataIndex = 0;
        while (data.hasRemaining()) {
            float tin = this.setupMaterialColor(data, format, neg, materialColorClone);
            this.blendPixel(resultPixel, materialColorClone, color, tin, affectFactor, blendType, dataRepository);
            newData.put(dataIndex++, (byte)(resultPixel[0] * 255.0f));
            newData.put(dataIndex++, (byte)(resultPixel[1] * 255.0f));
            newData.put(dataIndex++, (byte)(resultPixel[2] * 255.0f));
            newData.put(dataIndex++, (byte)-1);
        }
        if (texture.getType() == Texture.Type.TwoDimensional) {
            return new Texture2D(new Image(Image.Format.RGBA8, width, height, newData));
        }
        ArrayList<ByteBuffer> dataArray = new ArrayList<ByteBuffer>(1);
        dataArray.add(newData);
        return new Texture3D(new Image(Image.Format.RGBA8, width, height, depth, dataArray));
    }

    protected float setupMaterialColor(ByteBuffer data, Image.Format imageFormat, boolean neg, float[] materialColor) {
        float tin = 0.0f;
        byte pixelValue = data.get();
        float firstPixelValue = pixelValue >= 0 ? 1.0f - (float)pixelValue / 255.0f : (float)(~pixelValue + 1) / 255.0f;
        switch (imageFormat) {
            case ABGR8: {
                pixelValue = data.get();
                materialColor[2] = pixelValue >= 0 ? 1.0f - (float)pixelValue / 255.0f : (float)(~pixelValue + 1) / 255.0f;
                pixelValue = data.get();
                materialColor[1] = pixelValue >= 0 ? 1.0f - (float)pixelValue / 255.0f : (float)(~pixelValue + 1) / 255.0f;
                pixelValue = data.get();
                materialColor[0] = pixelValue >= 0 ? 1.0f - (float)pixelValue / 255.0f : (float)(~pixelValue + 1) / 255.0f;
                break;
            }
            case BGR8: {
                materialColor[2] = firstPixelValue;
                pixelValue = data.get();
                materialColor[1] = pixelValue >= 0 ? 1.0f - (float)pixelValue / 255.0f : (float)(~pixelValue + 1) / 255.0f;
                pixelValue = data.get();
                materialColor[0] = pixelValue >= 0 ? 1.0f - (float)pixelValue / 255.0f : (float)(~pixelValue + 1) / 255.0f;
                break;
            }
            case RGB8: {
                materialColor[0] = firstPixelValue;
                pixelValue = data.get();
                materialColor[1] = pixelValue >= 0 ? 1.0f - (float)pixelValue / 255.0f : (float)(~pixelValue + 1) / 255.0f;
                pixelValue = data.get();
                materialColor[2] = pixelValue >= 0 ? 1.0f - (float)pixelValue / 255.0f : (float)(~pixelValue + 1) / 255.0f;
                break;
            }
            case RGBA8: {
                materialColor[0] = firstPixelValue;
                pixelValue = data.get();
                materialColor[1] = pixelValue >= 0 ? 1.0f - (float)pixelValue / 255.0f : (float)(~pixelValue + 1) / 255.0f;
                pixelValue = data.get();
                materialColor[2] = pixelValue >= 0 ? 1.0f - (float)pixelValue / 255.0f : (float)(~pixelValue + 1) / 255.0f;
                data.get();
                break;
            }
            case Luminance8: {
                tin = neg ? 1.0f - firstPixelValue : firstPixelValue;
                neg = false;
                break;
            }
            case Luminance8Alpha8: {
                tin = neg ? 1.0f - firstPixelValue : firstPixelValue;
                neg = false;
                data.get();
                break;
            }
            case Luminance16: 
            case Luminance16Alpha16: 
            case Alpha16: 
            case Alpha8: 
            case ARGB4444: 
            case Depth: 
            case Depth16: 
            case Depth24: 
            case Depth32: 
            case Depth32F: 
            case DXT1: 
            case DXT1A: 
            case DXT3: 
            case DXT5: 
            case Intensity16: 
            case Intensity8: 
            case LATC: 
            case LTC: 
            case Luminance16F: 
            case Luminance16FAlpha16F: 
            case Luminance32F: 
            case RGB10: 
            case RGB111110F: 
            case RGB16: 
            case RGB16F: 
            case RGB16F_to_RGB111110F: 
            case RGB16F_to_RGB9E5: 
            case RGB32F: 
            case RGB565: 
            case RGB5A1: 
            case RGB9E5: 
            case RGBA16: 
            case RGBA16F: 
            case RGBA32F: {
                LOGGER.log(Level.WARNING, "Image type not yet supported for blending: {0}", (Object)imageFormat);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown image format type: " + (Object)((Object)imageFormat));
            }
        }
        if (neg) {
            materialColor[0] = 1.0f - materialColor[0];
            materialColor[1] = 1.0f - materialColor[1];
            materialColor[2] = 1.0f - materialColor[2];
        }
        return tin;
    }

    protected void blendPixel(float[] result, float[] materialColor, float[] color, float textureIntensity, float textureFactor, int blendtype, DataRepository dataRepository) {
        switch (blendtype) {
            case 0: {
                float facm = 1.0f - (textureIntensity *= textureFactor);
                result[0] = textureIntensity * color[0] + facm * materialColor[0];
                result[1] = textureIntensity * color[1] + facm * materialColor[1];
                result[2] = textureIntensity * color[2] + facm * materialColor[2];
                break;
            }
            case 1: {
                float facm = 1.0f - textureFactor;
                result[0] = (facm + (textureIntensity *= textureFactor) * materialColor[0]) * color[0];
                result[1] = (facm + textureIntensity * materialColor[1]) * color[1];
                result[2] = (facm + textureIntensity * materialColor[2]) * color[2];
                break;
            }
            case 4: {
                float facm = 1.0f - (textureIntensity *= textureFactor);
                if ((double)color[0] != 0.0) {
                    result[0] = (facm * materialColor[0] + textureIntensity * materialColor[0] / color[0]) * 0.5f;
                }
                if ((double)color[1] != 0.0) {
                    result[1] = (facm * materialColor[1] + textureIntensity * materialColor[1] / color[1]) * 0.5f;
                }
                if ((double)color[2] == 0.0) break;
                result[2] = (facm * materialColor[2] + textureIntensity * materialColor[2] / color[2]) * 0.5f;
                break;
            }
            case 8: {
                float facm = 1.0f - textureFactor;
                result[0] = 1.0f - (facm + (textureIntensity *= textureFactor) * (1.0f - materialColor[0])) * (1.0f - color[0]);
                result[1] = 1.0f - (facm + textureIntensity * (1.0f - materialColor[1])) * (1.0f - color[1]);
                result[2] = 1.0f - (facm + textureIntensity * (1.0f - materialColor[2])) * (1.0f - color[2]);
                break;
            }
            case 9: {
                float facm = 1.0f - textureFactor;
                result[0] = materialColor[0] < 0.5f ? color[0] * (facm + 2.0f * textureIntensity * materialColor[0]) : 1.0f - (facm + 2.0f * (textureIntensity *= textureFactor) * (1.0f - materialColor[0])) * (1.0f - color[0]);
                result[1] = materialColor[1] < 0.5f ? color[1] * (facm + 2.0f * textureIntensity * materialColor[1]) : 1.0f - (facm + 2.0f * textureIntensity * (1.0f - materialColor[1])) * (1.0f - color[1]);
                if (materialColor[2] < 0.5f) {
                    result[2] = color[2] * (facm + 2.0f * textureIntensity * materialColor[2]);
                    break;
                }
                result[2] = 1.0f - (facm + 2.0f * textureIntensity * (1.0f - materialColor[2])) * (1.0f - color[2]);
                break;
            }
            case 3: {
                result[0] = materialColor[0] - (textureIntensity *= textureFactor) * color[0];
                result[1] = materialColor[1] - textureIntensity * color[1];
                result[2] = materialColor[2] - textureIntensity * color[2];
                result[0] = FastMath.clamp(result[0], 0.0f, 1.0f);
                result[1] = FastMath.clamp(result[1], 0.0f, 1.0f);
                result[2] = FastMath.clamp(result[2], 0.0f, 1.0f);
                break;
            }
            case 2: {
                result[0] = ((textureIntensity *= textureFactor) * color[0] + materialColor[0]) * 0.5f;
                result[1] = (textureIntensity * color[1] + materialColor[1]) * 0.5f;
                result[2] = (textureIntensity * color[2] + materialColor[2]) * 0.5f;
                break;
            }
            case 6: {
                float facm = 1.0f - (textureIntensity *= textureFactor);
                result[0] = facm * color[0] + textureIntensity * Math.abs(materialColor[0] - color[0]);
                result[1] = facm * color[1] + textureIntensity * Math.abs(materialColor[1] - color[1]);
                result[2] = facm * color[2] + textureIntensity * Math.abs(materialColor[2] - color[2]);
                break;
            }
            case 5: {
                float col = (textureIntensity *= textureFactor) * color[0];
                result[0] = col < materialColor[0] ? col : materialColor[0];
                col = textureIntensity * color[1];
                result[1] = col < materialColor[1] ? col : materialColor[1];
                col = textureIntensity * color[2];
                result[2] = col < materialColor[2] ? col : materialColor[2];
                break;
            }
            case 7: {
                float col = (textureIntensity *= textureFactor) * color[0];
                result[0] = col > materialColor[0] ? col : materialColor[0];
                col = textureIntensity * color[1];
                result[1] = col > materialColor[1] ? col : materialColor[1];
                col = textureIntensity * color[2];
                result[2] = col > materialColor[2] ? col : materialColor[2];
                break;
            }
            case 10: {
                System.arraycopy(materialColor, 0, result, 0, 3);
                this.rampBlend(12, result, textureIntensity *= textureFactor, color, dataRepository);
                break;
            }
            case 11: {
                System.arraycopy(materialColor, 0, result, 0, 3);
                this.rampBlend(13, result, textureIntensity *= textureFactor, color, dataRepository);
                break;
            }
            case 12: {
                System.arraycopy(materialColor, 0, result, 0, 3);
                this.rampBlend(14, result, textureIntensity *= textureFactor, color, dataRepository);
                break;
            }
            case 13: {
                System.arraycopy(materialColor, 0, result, 0, 3);
                this.rampBlend(15, result, textureIntensity *= textureFactor, color, dataRepository);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown blend type: " + blendtype);
            }
        }
    }

    protected void rampBlend(int type, float[] rgb, float fac, float[] col, DataRepository dataRepository) {
        float facm = 1.0f - fac;
        MaterialHelper materialHelper = (MaterialHelper)dataRepository.getHelper(MaterialHelper.class);
        switch (type) {
            case 12: {
                if (rgb.length != 3) break;
                float[] colorTransformResult = new float[3];
                materialHelper.rgbToHsv(col[0], col[1], col[2], colorTransformResult);
                if (colorTransformResult[1] == 0.0f) break;
                float colH = colorTransformResult[0];
                materialHelper.rgbToHsv(rgb[0], rgb[1], rgb[2], colorTransformResult);
                materialHelper.hsvToRgb(colH, colorTransformResult[1], colorTransformResult[2], colorTransformResult);
                rgb[0] = facm * rgb[0] + fac * colorTransformResult[0];
                rgb[1] = facm * rgb[1] + fac * colorTransformResult[1];
                rgb[2] = facm * rgb[2] + fac * colorTransformResult[2];
                break;
            }
            case 13: {
                if (rgb.length != 3) break;
                float[] colorTransformResult = new float[3];
                materialHelper.rgbToHsv(rgb[0], rgb[1], rgb[2], colorTransformResult);
                float rH = colorTransformResult[0];
                float rS = colorTransformResult[1];
                float rV = colorTransformResult[2];
                if (rS == 0.0f) break;
                materialHelper.rgbToHsv(col[0], col[1], col[2], colorTransformResult);
                materialHelper.hsvToRgb(rH, facm * rS + fac * colorTransformResult[1], rV, rgb);
                break;
            }
            case 14: {
                if (rgb.length != 3) break;
                float[] rgbToHsv = new float[3];
                float[] colToHsv = new float[3];
                materialHelper.rgbToHsv(rgb[0], rgb[1], rgb[2], rgbToHsv);
                materialHelper.rgbToHsv(col[0], col[1], col[2], colToHsv);
                materialHelper.hsvToRgb(rgbToHsv[0], rgbToHsv[1], facm * rgbToHsv[2] + fac * colToHsv[2], rgb);
                break;
            }
            case 15: {
                if (rgb.length != 3) break;
                float[] rgbToHsv = new float[3];
                float[] colToHsv = new float[3];
                materialHelper.rgbToHsv(col[0], col[1], col[2], colToHsv);
                if (colToHsv[2] == 0.0f) break;
                materialHelper.rgbToHsv(rgb[0], rgb[1], rgb[2], rgbToHsv);
                materialHelper.hsvToRgb(colToHsv[0], colToHsv[1], rgbToHsv[2], rgbToHsv);
                rgb[0] = facm * rgb[0] + fac * rgbToHsv[0];
                rgb[1] = facm * rgb[1] + fac * rgbToHsv[1];
                rgb[2] = facm * rgb[2] + fac * rgbToHsv[2];
                break;
            }
            case 0: {
                rgb[0] = facm * rgb[0] + fac * col[0];
                if (rgb.length != 3) break;
                rgb[1] = facm * rgb[1] + fac * col[1];
                rgb[2] = facm * rgb[2] + fac * col[2];
                break;
            }
            case 1: {
                rgb[0] = rgb[0] + fac * col[0];
                if (rgb.length != 3) break;
                rgb[1] = rgb[1] + fac * col[1];
                rgb[2] = rgb[2] + fac * col[2];
                break;
            }
            case 2: {
                rgb[0] = rgb[0] * (facm + fac * col[0]);
                if (rgb.length != 3) break;
                rgb[1] = rgb[1] * (facm + fac * col[1]);
                rgb[2] = rgb[2] * (facm + fac * col[2]);
                break;
            }
            case 4: {
                rgb[0] = 1.0f - (facm + fac * (1.0f - col[0])) * (1.0f - rgb[0]);
                if (rgb.length != 3) break;
                rgb[1] = 1.0f - (facm + fac * (1.0f - col[1])) * (1.0f - rgb[1]);
                rgb[2] = 1.0f - (facm + fac * (1.0f - col[2])) * (1.0f - rgb[2]);
                break;
            }
            case 9: {
                rgb[0] = rgb[0] < 0.5f ? rgb[0] * (facm + 2.0f * fac * col[0]) : 1.0f - (facm + 2.0f * fac * (1.0f - col[0])) * (1.0f - rgb[0]);
                if (rgb.length != 3) break;
                rgb[1] = rgb[1] < 0.5f ? rgb[1] * (facm + 2.0f * fac * col[1]) : 1.0f - (facm + 2.0f * fac * (1.0f - col[1])) * (1.0f - rgb[1]);
                if (rgb[2] < 0.5f) {
                    rgb[2] = rgb[2] * (facm + 2.0f * fac * col[2]);
                    break;
                }
                rgb[2] = 1.0f - (facm + 2.0f * fac * (1.0f - col[2])) * (1.0f - rgb[2]);
                break;
            }
            case 3: {
                rgb[0] = rgb[0] - fac * col[0];
                if (rgb.length != 3) break;
                rgb[1] = rgb[1] - fac * col[1];
                rgb[2] = rgb[2] - fac * col[2];
                break;
            }
            case 5: {
                if ((double)col[0] != 0.0) {
                    rgb[0] = facm * rgb[0] + fac * rgb[0] / col[0];
                }
                if (rgb.length != 3) break;
                if ((double)col[1] != 0.0) {
                    rgb[1] = facm * rgb[1] + fac * rgb[1] / col[1];
                }
                if ((double)col[2] == 0.0) break;
                rgb[2] = facm * rgb[2] + fac * rgb[2] / col[2];
                break;
            }
            case 6: {
                rgb[0] = facm * rgb[0] + fac * Math.abs(rgb[0] - col[0]);
                if (rgb.length != 3) break;
                rgb[1] = facm * rgb[1] + fac * Math.abs(rgb[1] - col[1]);
                rgb[2] = facm * rgb[2] + fac * Math.abs(rgb[2] - col[2]);
                break;
            }
            case 7: {
                float tmp = fac * col[0];
                if (tmp < rgb[0]) {
                    rgb[0] = tmp;
                }
                if (rgb.length != 3) break;
                tmp = fac * col[1];
                if (tmp < rgb[1]) {
                    rgb[1] = tmp;
                }
                if (!((tmp = fac * col[2]) < rgb[2])) break;
                rgb[2] = tmp;
                break;
            }
            case 8: {
                float tmp = fac * col[0];
                if (tmp > rgb[0]) {
                    rgb[0] = tmp;
                }
                if (rgb.length != 3) break;
                tmp = fac * col[1];
                if (tmp > rgb[1]) {
                    rgb[1] = tmp;
                }
                if (!((tmp = fac * col[2]) > rgb[2])) break;
                rgb[2] = tmp;
                break;
            }
            case 10: {
                float f;
                float tmp;
                if ((double)rgb[0] != 0.0) {
                    tmp = 1.0f - fac * col[0];
                    if ((double)tmp <= 0.0) {
                        rgb[0] = 1.0f;
                    } else {
                        float f2;
                        tmp = rgb[0] / tmp;
                        rgb[0] = (double)f2 > 1.0 ? 1.0f : tmp;
                    }
                }
                if (rgb.length != 3) break;
                if ((double)rgb[1] != 0.0) {
                    tmp = 1.0f - fac * col[1];
                    if ((double)tmp <= 0.0) {
                        rgb[1] = 1.0f;
                    } else {
                        float f3;
                        tmp = rgb[1] / tmp;
                        rgb[1] = (double)f3 > 1.0 ? 1.0f : tmp;
                    }
                }
                if ((double)rgb[2] == 0.0) break;
                tmp = 1.0f - fac * col[2];
                if ((double)tmp <= 0.0) {
                    rgb[2] = 1.0f;
                    break;
                }
                tmp = rgb[2] / tmp;
                if ((double)f > 1.0) {
                    rgb[2] = 1.0f;
                    break;
                }
                rgb[2] = tmp;
                break;
            }
            case 11: {
                float f;
                float tmp = facm + fac * col[0];
                if ((double)tmp <= 0.0) {
                    rgb[0] = 0.0f;
                } else {
                    float f4;
                    tmp = 1.0f - (1.0f - rgb[0]) / tmp;
                    rgb[0] = (double)f4 < 0.0 ? 0.0f : ((double)tmp > 1.0 ? 1.0f : tmp);
                }
                if (rgb.length != 3) break;
                tmp = facm + fac * col[1];
                if ((double)tmp <= 0.0) {
                    rgb[1] = 0.0f;
                } else {
                    float f5;
                    tmp = 1.0f - (1.0f - rgb[1]) / tmp;
                    rgb[1] = (double)f5 < 0.0 ? 0.0f : ((double)tmp > 1.0 ? 1.0f : tmp);
                }
                tmp = facm + fac * col[2];
                if ((double)tmp <= 0.0) {
                    rgb[2] = 0.0f;
                    break;
                }
                tmp = 1.0f - (1.0f - rgb[2]) / tmp;
                if ((double)f < 0.0) {
                    rgb[2] = 0.0f;
                    break;
                }
                if ((double)tmp > 1.0) {
                    rgb[2] = 1.0f;
                    break;
                }
                rgb[2] = tmp;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ramp type: " + type);
            }
        }
    }

    public Texture convertToNormalMapTexture(Texture source, float strengthFactor) {
        Image image = source.getImage();
        BufferedImage sourceImage = ImageToAwt.convert(image, false, false, 0);
        BufferedImage heightMap = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
        BufferedImage bumpMap = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
        ColorConvertOp gscale = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        gscale.filter(sourceImage, heightMap);
        Vector3f S = new Vector3f();
        Vector3f T = new Vector3f();
        Vector3f N = new Vector3f();
        for (int x = 0; x < bumpMap.getWidth(); ++x) {
            for (int y = 0; y < bumpMap.getHeight(); ++y) {
                S.x = 1.0f;
                S.y = 0.0f;
                S.z = strengthFactor * (float)this.getHeight(heightMap, x + 1, y) - strengthFactor * (float)this.getHeight(heightMap, x - 1, y);
                T.x = 0.0f;
                T.y = 1.0f;
                T.z = strengthFactor * (float)this.getHeight(heightMap, x, y + 1) - strengthFactor * (float)this.getHeight(heightMap, x, y - 1);
                float den = (float)Math.sqrt(S.z * S.z + T.z * T.z + 1.0f);
                N.x = -S.z;
                N.y = -T.z;
                N.z = 1.0f;
                N.divideLocal(den);
                bumpMap.setRGB(x, y, this.vectorToColor(N.x, N.y, N.z));
            }
        }
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(image.getWidth() * image.getHeight() * 3);
        ImageToAwt.convert(bumpMap, Image.Format.RGB8, byteBuffer);
        return new Texture2D(new Image(Image.Format.RGB8, image.getWidth(), image.getHeight(), byteBuffer));
    }

    protected int getHeight(BufferedImage image, int x, int y) {
        if (x < 0) {
            x = 0;
        } else if (x >= image.getWidth()) {
            x = image.getWidth() - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= image.getHeight()) {
            y = image.getHeight() - 1;
        }
        return image.getRGB(x, y) & 0xFF;
    }

    protected int vectorToColor(float x, float y, float z) {
        int r = Math.round(255.0f * (x + 1.0f) / 2.0f);
        int g = Math.round(255.0f * (y + 1.0f) / 2.0f);
        int b = Math.round(255.0f * (z + 1.0f) / 2.0f);
        return -16777216 + (r << 16) + (g << 8) + b;
    }

    public Texture getTextureFromImage(Structure image, DataRepository dataRepository) throws BlenderFileException {
        Texture result = (Texture)dataRepository.getLoadedFeature(image.getOldMemoryAddress(), DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
        if (result == null) {
            String texturePath = image.getFieldValue("name").toString();
            Pointer pPackedFile = (Pointer)image.getFieldValue("packedfile");
            if (pPackedFile.isNull()) {
                LOGGER.info("Reading texture from file!");
                result = this.loadTextureFromFile(texturePath, dataRepository);
            } else {
                LOGGER.info("Packed texture. Reading directly from the blend file!");
                Structure packedFile = pPackedFile.fetchData(dataRepository.getInputStream()).get(0);
                Pointer pData = (Pointer)packedFile.getFieldValue("data");
                FileBlockHeader dataFileBlock = dataRepository.getFileBlock(pData.getOldMemoryAddress());
                dataRepository.getInputStream().setPosition(dataFileBlock.getBlockPosition());
                ImageLoader imageLoader = new ImageLoader();
                Image im = imageLoader.loadImage(dataRepository.getInputStream(), dataFileBlock.getBlockPosition(), true);
                if (im != null) {
                    result = new Texture2D(im);
                }
            }
            if (result != null) {
                result.setName(texturePath);
                result.setWrap(Texture.WrapMode.Repeat);
                dataRepository.addLoadedFeatures(image.getOldMemoryAddress(), image.getName(), image, result);
            }
        }
        return result;
    }

    protected Texture loadTextureFromFile(String name, DataRepository dataRepository) {
        AssetManager assetManager = dataRepository.getAssetManager();
        name = name.replaceAll("\\\\", "\\/");
        Texture result = null;
        ArrayList<String> assetNames = new ArrayList<String>();
        if (name.startsWith("//")) {
            String relativePath = name.substring(1);
            assetNames.add(relativePath);
            BlenderKey blenderKey = dataRepository.getBlenderKey();
            String blenderAssetFolder = blenderKey.getName().substring(0, blenderKey.getName().lastIndexOf(47));
            assetNames.add(blenderAssetFolder + '/' + relativePath);
        } else {
            String[] paths = name.split("\\/");
            StringBuilder sb = new StringBuilder(paths[paths.length - 1]);
            assetNames.add(paths[paths.length - 1]);
            for (int i = paths.length - 2; i >= 0; --i) {
                sb.insert(0, '/');
                sb.insert(0, paths[i]);
                assetNames.add(sb.toString());
            }
        }
        for (String assetName : assetNames) {
            try {
                result = assetManager.loadTexture(new TextureKey(assetName));
                break;
            }
            catch (AssetNotFoundException e) {
                LOGGER.fine(e.getLocalizedMessage());
            }
        }
        return result;
    }

    protected void closeStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }
    }

    public boolean shouldBeLoaded(Structure structure, DataRepository dataRepository) {
        return (dataRepository.getBlenderKey().getFeaturesToLoad() & 1) != 0;
    }

    protected static class CBData
    implements Cloneable {
        public float r;
        public float g;
        public float b;
        public float a;
        public float pos;
        public int cur;

        public CBData(Structure cbdataStructure) {
            this.r = ((Number)cbdataStructure.getFieldValue("r")).floatValue();
            this.g = ((Number)cbdataStructure.getFieldValue("g")).floatValue();
            this.b = ((Number)cbdataStructure.getFieldValue("b")).floatValue();
            this.a = ((Number)cbdataStructure.getFieldValue("a")).floatValue();
            this.pos = ((Number)cbdataStructure.getFieldValue("pos")).floatValue();
            this.cur = ((Number)cbdataStructure.getFieldValue("cur")).intValue();
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    protected static class ColorBand {
        public int flag;
        public int tot;
        public int cur;
        public int ipotype;
        public CBData[] data = new CBData[32];

        public ColorBand(Structure colorbandStructure) {
            this.flag = ((Number)colorbandStructure.getFieldValue("flag")).intValue();
            this.tot = ((Number)colorbandStructure.getFieldValue("tot")).intValue();
            this.cur = ((Number)colorbandStructure.getFieldValue("cur")).intValue();
            this.ipotype = ((Number)colorbandStructure.getFieldValue("ipotype")).intValue();
            DynamicArray data = (DynamicArray)colorbandStructure.getFieldValue("data");
            for (int i = 0; i < data.getTotalSize(); ++i) {
                this.data[i] = new CBData((Structure)data.get(i));
            }
        }
    }

    protected static class TexResult
    implements Cloneable {
        public float tin;
        public float tr;
        public float tg;
        public float tb;
        public float ta;
        public int talpha;
        public float[] nor;

        protected TexResult() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageType {
        AWT,
        TGA,
        DDS;

    }
}

