/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ant_deb_task;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Date;

public class BuildDeb {
    private static final String FILE_HEADER_FORMAT = "{0}{1}0     0     100644  {2}`\n";
    private static final String DEBIAN_BINARY_CONTENT = "2.0\n";
    private static final String DEBIAN_BINARY_NAME = "debian-binary";
    private static final String CONTROL_NAME = "control.tar.gz";
    private static final String DATA_NAME = "data.tar.gz";

    public static void buildDeb(File debFile, File controlFile, File dataFile) throws IOException {
        int read;
        int read2;
        long now = new Date().getTime() / 1000L;
        FileOutputStream deb = new FileOutputStream(debFile);
        ((OutputStream)deb).write("!<arch>\n".getBytes());
        BuildDeb.startFileEntry(deb, DEBIAN_BINARY_NAME, now, DEBIAN_BINARY_CONTENT.length());
        ((OutputStream)deb).write(DEBIAN_BINARY_CONTENT.getBytes());
        BuildDeb.endFileEntry(deb, DEBIAN_BINARY_CONTENT.length());
        BuildDeb.startFileEntry(deb, CONTROL_NAME, now, controlFile.length());
        FileInputStream control = new FileInputStream(controlFile);
        byte[] buffer = new byte[1024];
        while ((read2 = control.read(buffer)) != -1) {
            ((OutputStream)deb).write(buffer, 0, read2);
        }
        control.close();
        BuildDeb.endFileEntry(deb, controlFile.length());
        BuildDeb.startFileEntry(deb, DATA_NAME, now, dataFile.length());
        FileInputStream data = new FileInputStream(dataFile);
        while ((read = data.read(buffer)) != -1) {
            ((OutputStream)deb).write(buffer, 0, read);
        }
        data.close();
        BuildDeb.endFileEntry(deb, dataFile.length());
        ((OutputStream)deb).close();
    }

    private static void startFileEntry(OutputStream deb, String name, long time, long length) throws IOException {
        String fileHeader = MessageFormat.format(FILE_HEADER_FORMAT, BuildDeb.padd(name, 16), BuildDeb.padd(time, 12), BuildDeb.padd(length, 10));
        deb.write(fileHeader.getBytes());
    }

    private static void endFileEntry(OutputStream deb, long length) throws IOException {
        if (length % 2L == 1L) {
            deb.write("\n".getBytes());
        }
    }

    private static String padd(long number, int length) {
        return BuildDeb.padd(Long.toString(number), length);
    }

    private static String padd(String text, int length) {
        StringBuffer buffer = new StringBuffer(text);
        for (int i = 0; i < length - text.length(); ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public static void main(String[] args) throws IOException {
        BuildDeb.buildDeb(new File(args[0]), new File(args[1]), new File(args[2]));
    }
}

