/*
 * Decompiled with CFR 0.152.
 */
package tgaimageplugin;

import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import tgaimageplugin.Utils;

public class TGAHeader {
    private final int idLength;
    private final int firstColorMapEntry;
    private final int colorMapLength;
    private final int colorMapEntrySize;
    private final int imageXOrigin;
    private final int imageYOrigin;
    private final int imageWidth;
    private final int imageHeight;
    private final int pixelDepth;
    private final int imageDescriptor;
    private final ImageType imageType;
    private final ColorMapType colorMapType;
    private final String imageID;
    private final FirstPixelDestination fpd;

    public static TGAHeader create(ImageInputStream in) throws IOException {
        return new TGAHeader(in);
    }

    protected TGAHeader(ImageInputStream in) throws IOException {
        in.seek(0L);
        in.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.idLength = in.readUnsignedByte();
        this.colorMapType = ColorMapType.values()[in.readUnsignedByte()];
        int it = in.readUnsignedByte();
        ImageType tp = null;
        for (ImageType e : ImageType.values()) {
            if (e.code() != it) continue;
            tp = e;
        }
        this.imageType = tp;
        this.firstColorMapEntry = in.readUnsignedShort();
        this.colorMapLength = in.readUnsignedShort();
        this.colorMapEntrySize = in.readUnsignedByte();
        this.imageXOrigin = in.readShort();
        this.imageYOrigin = in.readShort();
        this.imageWidth = in.readUnsignedShort();
        this.imageHeight = in.readUnsignedShort();
        this.pixelDepth = in.readUnsignedByte();
        this.imageDescriptor = in.readUnsignedByte();
        if (this.idLength != 0) {
            byte[] buffer = new byte[this.idLength];
            in.readFully(buffer);
            this.imageID = new String(buffer, "ascii");
        } else {
            this.imageID = "";
        }
        int bit5 = Utils.bit(this.imageDescriptor, 5);
        int bit4 = Utils.bit(this.imageDescriptor, 4);
        this.fpd = bit5 == 0 && bit4 == 0 ? FirstPixelDestination.BOTTOM_LEFT : (bit5 == 0 && bit4 == 1 ? FirstPixelDestination.BOTTOM_RIGHT : (bit5 == 1 && bit4 == 0 ? FirstPixelDestination.TOP_LEFT : FirstPixelDestination.TOP_RIGHT));
    }

    public FirstPixelDestination getFirstPixelDestination() {
        return this.fpd;
    }

    public String getImageID() {
        return this.imageID;
    }

    public int getIdLength() {
        return this.idLength;
    }

    public ColorMapType getColorMapType() {
        return this.colorMapType;
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public int getFirstColorMapEntry() {
        return this.firstColorMapEntry;
    }

    public int getColorMapLength() {
        return this.colorMapLength;
    }

    public int getColorMapEntrySize() {
        return this.colorMapEntrySize;
    }

    public int getImageXOrigin() {
        return this.imageXOrigin;
    }

    public int getImageYOrigin() {
        return this.imageYOrigin;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getPixelDepth() {
        return this.pixelDepth;
    }

    public int getImageDescriptor() {
        return this.imageDescriptor;
    }

    public String toString() {
        return "TGA Image\nID: " + this.getImageID() + "\nColor Map: " + (Object)((Object)this.getColorMapType()) + "\nImageType: " + (Object)((Object)this.getImageType()) + "\nXOrigin: " + this.getImageXOrigin() + "\nYOrigin: " + this.getImageYOrigin() + "\nImage Width: " + this.getImageWidth() + "\nImageHeight: " + this.getImageHeight() + "\nPixel Depth: " + this.getPixelDepth();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageType {
        NO_IMAGE_DATA(0),
        UNCOMPRESSED_COLOR_MAPPED(1),
        UNCOMPRESSED_TRUE_COLOR(2),
        UNCOMPRESSED_BLACK_AND_WHITE(3),
        RUNLENGTH_COLOR_MAPPED(9),
        RUNLENGTH_TRUE_COLOR(10),
        RUNLENGTH_BLACK_AND_WHITE(11);

        private int code;

        private ImageType(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorMapType {
        NO_COLOR_MAP,
        COLOR_MAP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FirstPixelDestination {
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        TOP_RIGHT;

    }
}

