/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.ProxySurface;
import jogamp.nativewindow.windows.GDI;
import jogamp.opengl.windows.wgl.WindowsWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfigurationFactory;

public class WindowsDummyWGLDrawable
extends WindowsWGLDrawable {
    private static final int f_dim = 64;
    private long hwnd = GDI.CreateDummyWindow((int)0, (int)0, (int)64, (int)64);
    private long hdc;

    protected WindowsDummyWGLDrawable(GLDrawableFactory gLDrawableFactory, GLCapabilitiesImmutable gLCapabilitiesImmutable, AbstractGraphicsScreen abstractGraphicsScreen) {
        super(gLDrawableFactory, (NativeSurface)new ProxySurface((AbstractGraphicsConfiguration)WindowsWGLGraphicsConfigurationFactory.createDefaultGraphicsConfiguration(gLCapabilitiesImmutable, abstractGraphicsScreen)), true);
        if (0L == this.hwnd) {
            throw new GLException("Error hwnd 0, werr: " + GDI.GetLastError());
        }
        ProxySurface proxySurface = (ProxySurface)this.getNativeSurface();
        proxySurface.setSize(64, 64);
        if (1 >= this.lockSurface()) {
            throw new GLException("WindowsDummyWGLDrawable: surface not ready (lockSurface)");
        }
        try {
            WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)proxySurface.getGraphicsConfiguration().getNativeGraphicsConfiguration();
            windowsWGLGraphicsConfiguration.updateGraphicsConfiguration(gLDrawableFactory, (NativeSurface)proxySurface, null);
            if (DEBUG) {
                System.err.println("!!! WindowsDummyWGLDrawable: " + windowsWGLGraphicsConfiguration);
            }
        }
        catch (Throwable throwable) {
            this.destroyImpl();
            throw new GLException(throwable);
        }
        finally {
            this.unlockSurface();
        }
    }

    public static WindowsDummyWGLDrawable create(GLDrawableFactory gLDrawableFactory, GLProfile gLProfile, AbstractGraphicsScreen abstractGraphicsScreen) {
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setDepthBits(16);
        gLCapabilities.setDoubleBuffered(true);
        gLCapabilities.setOnscreen(true);
        return new WindowsDummyWGLDrawable(gLDrawableFactory, gLCapabilities, abstractGraphicsScreen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lockSurface() throws GLException {
        int n = 1;
        ProxySurface proxySurface = (ProxySurface)this.getNativeSurface();
        AbstractGraphicsDevice abstractGraphicsDevice = proxySurface.getGraphicsConfiguration().getNativeGraphicsConfiguration().getScreen().getDevice();
        abstractGraphicsDevice.lock();
        try {
            n = proxySurface.lockSurface();
            if (3 == n) {
                if (0L == this.hdc) {
                    this.hdc = GDI.GetDC((long)this.hwnd);
                    proxySurface.setSurfaceHandle(this.hdc);
                    if (0L == this.hdc) {
                        n = 1;
                        proxySurface.unlockSurface();
                        throw new GLException("Error hdc 0, werr: " + GDI.GetLastError());
                    }
                }
            } else {
                Throwable throwable = new Throwable("Error lock failed - res " + n + ", hwnd " + WindowsDummyWGLDrawable.toHexString(this.hwnd) + ", hdc " + WindowsDummyWGLDrawable.toHexString(this.hdc));
                throwable.printStackTrace();
            }
        }
        finally {
            if (1 == n) {
                abstractGraphicsDevice.unlock();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockSurface() {
        ProxySurface proxySurface = (ProxySurface)this.getNativeSurface();
        proxySurface.validateSurfaceLocked();
        AbstractGraphicsDevice abstractGraphicsDevice = proxySurface.getGraphicsConfiguration().getNativeGraphicsConfiguration().getScreen().getDevice();
        try {
            if (0L != this.hdc && 0L != this.hwnd && proxySurface.getSurfaceRecursionCount() == 0) {
                GDI.ReleaseDC((long)this.hwnd, (long)this.hdc);
                this.hdc = 0L;
                proxySurface.setSurfaceHandle(this.hdc);
            }
            this.surface.unlockSurface();
        }
        finally {
            abstractGraphicsDevice.unlock();
        }
    }

    public void setSize(int n, int n2) {
    }

    @Override
    public int getWidth() {
        return 1;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new WindowsWGLContext(this, gLContext);
    }

    @Override
    protected void destroyImpl() {
        if (this.hdc != 0L) {
            GDI.ReleaseDC((long)this.hwnd, (long)this.hdc);
            this.hdc = 0L;
            ProxySurface proxySurface = (ProxySurface)this.getNativeSurface();
            proxySurface.setSurfaceHandle(this.hdc);
        }
        if (this.hwnd != 0L) {
            GDI.ShowWindow((long)this.hwnd, (int)0);
            GDI.DestroyDummyWindow((long)this.hwnd);
            this.hwnd = 0L;
        }
    }
}

