/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import com.jogamp.common.util.VersionNumber;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.x11.X11GraphicsDevice;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.x11.X11Util;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLContextShareSet;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.GLXExt;
import jogamp.opengl.x11.glx.GLXExtImpl;
import jogamp.opengl.x11.glx.GLXExtProcAddressTable;
import jogamp.opengl.x11.glx.X11GLXDrawableFactory;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfiguration;

public abstract class X11GLXContext
extends GLContextImpl {
    protected static final boolean TRACE_CONTEXT_CURRENT = false;
    private static final Map functionNameMap = new HashMap();
    private static final Map extensionNameMap;
    private VersionNumber glXVersion;
    private boolean glXVersionOneThreeCapable;
    private boolean glXQueryExtensionsStringInitialized;
    private boolean glXQueryExtensionsStringAvailable;
    private GLXExt glXExt;
    private GLXExtProcAddressTable glXExtProcAddressTable;
    private int hasSwapIntervalSGI = 0;
    protected boolean isDirect;
    private boolean isVendorATI = false;

    X11GLXContext(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        super(gLDrawableImpl, gLContext);
    }

    protected void resetState() {
        this.glXVersion = null;
        this.glXVersionOneThreeCapable = false;
        this.glXQueryExtensionsStringInitialized = false;
        this.glXQueryExtensionsStringAvailable = false;
        this.glXExtProcAddressTable = null;
        this.hasSwapIntervalSGI = 0;
        this.isDirect = false;
    }

    @Override
    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.getGLXExtProcAddressTable();
    }

    public final GLXExtProcAddressTable getGLXExtProcAddressTable() {
        return this.glXExtProcAddressTable;
    }

    @Override
    public Object getPlatformGLExtensions() {
        return this.getGLXExt();
    }

    public GLXExt getGLXExt() {
        if (this.glXExt == null) {
            this.glXExt = new GLXExtImpl(this);
        }
        return this.glXExt;
    }

    @Override
    protected Map getFunctionNameMap() {
        return functionNameMap;
    }

    @Override
    protected Map getExtensionNameMap() {
        return extensionNameMap;
    }

    public final boolean isGLXVersionGreaterEqualOneThree() {
        if (null == this.glXVersion) {
            X11GLXDrawableFactory x11GLXDrawableFactory = (X11GLXDrawableFactory)this.drawable.getFactoryImpl();
            X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
            X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)x11GLXGraphicsConfiguration.getScreen().getDevice();
            this.glXVersion = X11GLXDrawableFactory.getGLXVersion(x11GraphicsDevice);
            this.glXVersionOneThreeCapable = null != this.glXVersion ? this.glXVersion.compareTo((Object)X11GLXDrawableFactory.versionOneThree) >= 0 : false;
        }
        return this.glXVersionOneThreeCapable;
    }

    @Override
    public final boolean isGLReadDrawableAvailable() {
        return this.isGLXVersionGreaterEqualOneThree();
    }

    private final boolean glXMakeContextCurrent(long l, long l2, long l3, long l4) {
        boolean bl;
        block4: {
            bl = false;
            try {
                if (this.glXVersionOneThreeCapable) {
                    bl = GLX.glXMakeContextCurrent(l, l2, l3, l4);
                    break block4;
                }
                if (l2 == l3) {
                    bl = GLX.glXMakeCurrent(l, l2, l4);
                    break block4;
                }
                throw new InternalError("Given readDrawable but no driver support");
            }
            catch (RuntimeException runtimeException) {
                if (!DEBUG) break block4;
                System.err.println("Warning: X11GLXContext.glXMakeContextCurrent failed: " + runtimeException + ", with " + "dpy " + X11GLXContext.toHexString(l) + ", write " + X11GLXContext.toHexString(l2) + ", read " + X11GLXContext.toHexString(l3) + ", ctx " + X11GLXContext.toHexString(l4));
                runtimeException.printStackTrace();
            }
        }
        return bl;
    }

    @Override
    protected void destroyContextARBImpl(long l) {
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
        long l2 = x11GLXGraphicsConfiguration.getScreen().getDevice().getHandle();
        this.glXMakeContextCurrent(l2, 0L, 0L, 0L);
        GLX.glXDestroyContext(l2, l);
    }

    @Override
    protected long createContextARBImpl(long l, boolean bl, int n, int n2, int n3) {
        long l2;
        long l3;
        block14: {
            this.updateGLXProcAddressTable();
            GLXExt gLXExt = this.getGLXExt();
            if (DEBUG) {
                System.err.println("X11GLXContext.createContextARBImpl: " + X11GLXContext.getGLVersion(n2, n3, n, "@creation") + ", handle " + X11GLXContext.toHexString(this.drawable.getHandle()) + ", share " + X11GLXContext.toHexString(l) + ", direct " + bl + ", glXCreateContextAttribsARB: " + X11GLXContext.toHexString(this.glXExtProcAddressTable._addressof_glXCreateContextAttribsARB));
                Thread.dumpStack();
            }
            boolean bl2 = 0 != (2 & n);
            boolean bl3 = 0 != (0x10 & n);
            boolean bl4 = 0 != (0x40 & n);
            l3 = 0L;
            int[] nArray = new int[]{8337, n2, 8338, n3, 32785, 32788, 8340, 0, 0, 0, 0};
            if (n2 > 3 || n2 == 3 && n3 >= 2) {
                nArray[8] = 37158;
                nArray[9] = bl2 ? 2 : 1;
            }
            if (n2 >= 3) {
                if (!bl2 && bl3) {
                    nArray[7] = nArray[7] | 2;
                }
                if (bl4) {
                    nArray[7] = nArray[7] | 1;
                }
            }
            X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
            AbstractGraphicsDevice abstractGraphicsDevice = x11GLXGraphicsConfiguration.getScreen().getDevice();
            l2 = abstractGraphicsDevice.getHandle();
            try {
                X11Util.XSync((long)l2, (boolean)false);
                l3 = gLXExt.glXCreateContextAttribsARB(l2, x11GLXGraphicsConfiguration.getFBConfig(), l, bl, nArray, 0);
                X11Util.XSync((long)l2, (boolean)false);
            }
            catch (RuntimeException runtimeException) {
                if (!DEBUG) break block14;
                Throwable throwable = new Throwable("Info: X11GLXContext.createContextARBImpl glXCreateContextAttribsARB failed with " + X11GLXContext.getGLVersion(n2, n3, n, "@creation"), runtimeException);
                throwable.printStackTrace();
            }
        }
        if (0L != l3) {
            if (!this.glXMakeContextCurrent(l2, this.drawable.getHandle(), this.drawableRead.getHandle(), l3)) {
                if (DEBUG) {
                    System.err.println("X11GLXContext.createContextARBImpl couldn't make current " + X11GLXContext.getGLVersion(n2, n3, n, "@creation"));
                }
                this.glXMakeContextCurrent(l2, 0L, 0L, 0L);
                GLX.glXDestroyContext(l2, l3);
                l3 = 0L;
            } else if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": createContextARBImpl: OK " + X11GLXContext.getGLVersion(n2, n3, n, "@creation") + ", share " + l + ", direct " + bl);
            }
        } else if (DEBUG) {
            System.err.println(X11GLXContext.getThreadName() + ": createContextARBImpl: NO " + X11GLXContext.getGLVersion(n2, n3, n, "@creation"));
        }
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean createImpl() {
        X11Util.setX11ErrorHandler((boolean)true, (boolean)true);
        try {
            boolean bl = this.createImplRaw();
            return bl;
        }
        finally {
            X11Util.setX11ErrorHandler((boolean)false, (boolean)false);
        }
    }

    private boolean createImplRaw() {
        boolean bl = true;
        this.isDirect = false;
        X11GLXDrawableFactory x11GLXDrawableFactory = (X11GLXDrawableFactory)this.drawable.getFactoryImpl();
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = x11GLXGraphicsConfiguration.getScreen().getDevice();
        X11GLXContext x11GLXContext = (X11GLXContext)x11GLXDrawableFactory.getOrCreateSharedContextImpl(abstractGraphicsDevice);
        long l = abstractGraphicsDevice.getHandle();
        this.isGLReadDrawableAvailable();
        X11GLXContext x11GLXContext2 = (X11GLXContext)GLContextShareSet.getShareContext(this);
        long l2 = 0L;
        if (x11GLXContext2 != null) {
            l2 = x11GLXContext2.getHandle();
            if (l2 == 0L) {
                throw new GLException("GLContextShareSet returned an invalid OpenGL context");
            }
            bl = GLX.glXIsDirect(l, l2);
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)x11GLXGraphicsConfiguration.getChosenCapabilities();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        this.isVendorATI = x11GLXDrawableFactory.isGLXVendorATI(abstractGraphicsDevice);
        if (x11GLXGraphicsConfiguration.getFBConfigID() < 0) {
            if (gLProfile.isGL3()) {
                throw new GLException("Unable to create OpenGL >= 3.1 context");
            }
            this.contextHandle = GLX.glXCreateContext(l, x11GLXGraphicsConfiguration.getXVisualInfo(), l2, bl);
            if (this.contextHandle == 0L) {
                throw new GLException("Unable to create context(0)");
            }
            if (!this.glXMakeContextCurrent(l, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                throw new GLException("Error making temp context(0) current: display " + X11GLXContext.toHexString(l) + ", context " + X11GLXContext.toHexString(this.contextHandle) + ", drawable " + this.drawable);
            }
            this.setGLFunctionAvailability(true, 0, 0, 34);
            this.isDirect = GLX.glXIsDirect(l, this.contextHandle);
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": createContextImpl: OK (old-1) share " + l2 + ", direct " + this.isDirect + "/" + bl);
            }
            return true;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        boolean bl2 = false;
        if (null != x11GLXContext && x11GLXContext.isCreatedWithARBMethod()) {
            this.contextHandle = this.createContextARB(l2, bl, nArray2, nArray, nArray3);
            bl2 = true;
            if (DEBUG && 0L != this.contextHandle) {
                System.err.println(X11GLXContext.getThreadName() + ": createContextImpl: OK (ARB, using sharedContext) share " + l2);
            }
        }
        long l3 = 0L;
        if (0L == this.contextHandle) {
            l3 = GLX.glXCreateNewContext(l, x11GLXGraphicsConfiguration.getFBConfig(), 32788, l2, bl);
            if (l3 == 0L) {
                throw new GLException("Unable to create temp OpenGL context(1)");
            }
            if (!this.glXMakeContextCurrent(l, this.drawable.getHandle(), this.drawableRead.getHandle(), l3)) {
                throw new GLException("Error making temp context(1) current: display " + X11GLXContext.toHexString(l) + ", context " + X11GLXContext.toHexString(l3) + ", drawable " + this.drawable);
            }
            this.setGLFunctionAvailability(true, 0, 0, 34);
            boolean bl3 = this.isFunctionAvailable("glXCreateContextAttribsARB");
            this.glXMakeContextCurrent(l, 0L, 0L, 0L);
            if (!bl2) {
                if (bl3 && this.isExtensionAvailable("GLX_ARB_create_context")) {
                    this.contextHandle = this.createContextARB(l2, bl, nArray2, nArray, nArray3);
                    bl2 = true;
                    if (DEBUG) {
                        if (0L != this.contextHandle) {
                            System.err.println(X11GLXContext.getThreadName() + ": createContextImpl: OK (ARB, initial) share " + l2);
                        } else {
                            System.err.println(X11GLXContext.getThreadName() + ": createContextImpl: NOT OK (ARB, initial) - creation failed - share " + l2);
                        }
                    }
                } else if (DEBUG) {
                    System.err.println(X11GLXContext.getThreadName() + ": createContextImpl: NOT OK (ARB, initial) - extension not available - share " + l2);
                }
            }
        }
        if (0L != this.contextHandle) {
            if (0L != l3) {
                this.glXMakeContextCurrent(l, 0L, 0L, 0L);
                GLX.glXDestroyContext(l, l3);
                if (!this.glXMakeContextCurrent(l, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                    throw new GLException("Cannot make previous verified context current");
                }
            }
        } else {
            if (gLProfile.isGL3()) {
                this.glXMakeContextCurrent(l, 0L, 0L, 0L);
                GLX.glXDestroyContext(l, l3);
                throw new GLException("X11GLXContext.createContextImpl failed, but context > GL2 requested " + X11GLXContext.getGLVersion(nArray2[0], nArray[0], nArray3[0], "@creation") + ", ");
            }
            if (DEBUG) {
                System.err.println("X11GLXContext.createContextImpl failed, fall back to !ARB context " + X11GLXContext.getGLVersion(nArray2[0], nArray[0], nArray3[0], "@creation"));
            }
            this.contextHandle = l3;
            if (!this.glXMakeContextCurrent(l, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                this.glXMakeContextCurrent(l, 0L, 0L, 0L);
                GLX.glXDestroyContext(l, l3);
                throw new GLException("Error making context(1) current: display " + X11GLXContext.toHexString(l) + ", context " + X11GLXContext.toHexString(this.contextHandle) + ", drawable " + this.drawable);
            }
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": createContextImpl: OK (old-2) share " + l2);
            }
        }
        this.isDirect = GLX.glXIsDirect(l, this.contextHandle);
        if (DEBUG) {
            System.err.println(X11GLXContext.getThreadName() + ": createContextImpl: OK direct " + this.isDirect + "/" + bl);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void makeCurrentImpl(boolean bl) throws GLException {
        long l = this.drawable.getNativeSurface().getDisplayHandle();
        if (GLX.glXGetCurrentContext() != this.contextHandle) {
            X11Util.setX11ErrorHandler((boolean)true, (boolean)true);
            try {
                if (!this.glXMakeContextCurrent(l, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                    throw new GLException("Error making context current: " + this);
                }
            }
            finally {
                X11Util.setX11ErrorHandler((boolean)false, (boolean)false);
            }
            if (DEBUG && bl) {
                System.err.println(X11GLXContext.getThreadName() + ": glXMakeCurrent(display " + X11GLXContext.toHexString(l) + ", drawable " + X11GLXContext.toHexString(this.drawable.getHandle()) + ", drawableRead " + X11GLXContext.toHexString(this.drawableRead.getHandle()) + ", context " + X11GLXContext.toHexString(this.contextHandle) + ") succeeded");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseImpl() throws GLException {
        long l = this.drawable.getNativeSurface().getDisplayHandle();
        X11Util.setX11ErrorHandler((boolean)true, (boolean)true);
        try {
            if (!this.glXMakeContextCurrent(l, 0L, 0L, 0L)) {
                throw new GLException("Error freeing OpenGL context");
            }
        }
        finally {
            X11Util.setX11ErrorHandler((boolean)false, (boolean)false);
        }
    }

    @Override
    protected void destroyImpl() throws GLException {
        long l = this.drawable.getNativeSurface().getDisplayHandle();
        if (DEBUG) {
            System.err.println("glXDestroyContext(dpy " + X11GLXContext.toHexString(l) + ", ctx " + X11GLXContext.toHexString(this.contextHandle) + ")");
        }
        GLX.glXDestroyContext(l, this.contextHandle);
        if (DEBUG) {
            System.err.println("!!! Destroyed OpenGL context " + this.contextHandle);
        }
    }

    @Override
    protected void copyImpl(GLContext gLContext, int n) throws GLException {
        long l = this.getHandle();
        long l2 = gLContext.getHandle();
        long l3 = this.drawable.getNativeSurface().getDisplayHandle();
        if (0L == l3) {
            throw new GLException("Connection to X display not yet set up");
        }
        GLX.glXCopyContext(l3, l2, l, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void updateGLXProcAddressTable() {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        String string = abstractGraphicsDevice.getUniqueID();
        if (DEBUG) {
            System.err.println(X11GLXContext.getThreadName() + ": !!! Initializing GLX extension address table: " + string);
        }
        this.glXQueryExtensionsStringInitialized = false;
        this.glXQueryExtensionsStringAvailable = false;
        GLXExtProcAddressTable gLXExtProcAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            gLXExtProcAddressTable = (GLXExtProcAddressTable)((Object)mappedGLXProcAddress.get(string));
        }
        if (null != gLXExtProcAddressTable) {
            this.glXExtProcAddressTable = gLXExtProcAddressTable;
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": !!! GLContext GLX ProcAddressTable reusing key(" + string + ") -> " + ((Object)((Object)gLXExtProcAddressTable)).hashCode());
            }
        } else {
            if (this.glXExtProcAddressTable == null) {
                this.glXExtProcAddressTable = new GLXExtProcAddressTable(new GLProcAddressResolver());
            }
            this.resetProcAddressTable(this.getGLXExtProcAddressTable());
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLXProcAddress.put(string, this.getGLXExtProcAddressTable());
                if (DEBUG) {
                    System.err.println(X11GLXContext.getThreadName() + ": !!! GLContext GLX ProcAddressTable mapping key(" + string + ") -> " + ((Object)((Object)this.getGLXExtProcAddressTable())).hashCode());
                    Thread.dumpStack();
                }
            }
        }
    }

    @Override
    public synchronized String getPlatformExtensionsString() {
        if (!this.glXQueryExtensionsStringInitialized) {
            this.glXQueryExtensionsStringAvailable = this.getDrawableImpl().getGLDynamicLookupHelper().dynamicLookupFunction("glXQueryExtensionsString") != 0L;
            this.glXQueryExtensionsStringInitialized = true;
        }
        if (this.glXQueryExtensionsStringAvailable) {
            NativeSurface nativeSurface = this.drawable.getNativeSurface();
            String string = GLX.glXQueryExtensionsString(nativeSurface.getDisplayHandle(), nativeSurface.getScreenIndex());
            if (DEBUG) {
                System.err.println("!!! GLX extensions: " + string);
            }
            return string;
        }
        return "";
    }

    @Override
    public boolean isExtensionAvailable(String string) {
        if (string.equals("GL_ARB_pbuffer") || string.equals("GL_ARB_pixel_format")) {
            return this.getGLDrawable().getFactory().canCreateGLPbuffer(this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration().getScreen().getDevice());
        }
        return super.isExtensionAvailable(string);
    }

    @Override
    protected void setSwapIntervalImpl(int n) {
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)x11GLXGraphicsConfiguration.getChosenCapabilities();
        if (!gLCapabilitiesImmutable.isOnscreen()) {
            return;
        }
        GLXExt gLXExt = this.getGLXExt();
        if (0 == this.hasSwapIntervalSGI) {
            try {
                this.hasSwapIntervalSGI = gLXExt.isExtensionAvailable("GLX_SGI_swap_control") ? 1 : -1;
            }
            catch (Throwable throwable) {
                this.hasSwapIntervalSGI = 1;
            }
        }
        if (this.hasSwapIntervalSGI > 0) {
            try {
                if (0 == gLXExt.glXSwapIntervalSGI(n)) {
                    this.currentSwapInterval = n;
                }
            }
            catch (Throwable throwable) {
                this.hasSwapIntervalSGI = -1;
            }
        }
    }

    @Override
    public ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        return this.getGLXExt().glXAllocateMemoryNV(n, f, f2, f3);
    }

    @Override
    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    @Override
    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    @Override
    public void bindPbufferToTexture() {
        throw new GLException("Should not call this");
    }

    @Override
    public void releasePbufferFromTexture() {
        throw new GLException("Should not call this");
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" [");
        super.append(stringBuffer);
        stringBuffer.append(", direct ");
        stringBuffer.append(this.isDirect);
        stringBuffer.append("] ");
        return stringBuffer.toString();
    }

    static {
        functionNameMap.put("glAllocateMemoryNV", "glXAllocateMemoryNV");
        functionNameMap.put("glFreeMemoryNV", "glXFreeMemoryNV");
        extensionNameMap = new HashMap();
        extensionNameMap.put("GL_ARB_pbuffer", "GLX_SGIX_pbuffer");
        extensionNameMap.put("GL_ARB_pixel_format", "GLX_SGIX_pbuffer");
    }
}

