/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.loaderv2.types.helper.PaddingAttributeParser;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.logging.Logger;

public class Border
implements EffectImpl {
    private Logger log = Logger.getLogger(Border.class.getName());
    private Color colorLeft = Color.WHITE;
    private Color colorRight = Color.WHITE;
    private Color colorTop = Color.WHITE;
    private Color colorBottom = Color.WHITE;
    private SizeValue borderLeft = new SizeValue("1px");
    private SizeValue borderRight = new SizeValue("1px");
    private SizeValue borderTop = new SizeValue("1px");
    private SizeValue borderBottom = new SizeValue("1px");
    private SizeValue insetLeft = new SizeValue("0px");
    private SizeValue insetRight = new SizeValue("0px");
    private SizeValue insetTop = new SizeValue("0px");
    private SizeValue insetBottom = new SizeValue("0px");

    @Override
    public void activate(Nifty nifty, Element element, EffectProperties parameter) {
        try {
            PaddingAttributeParser parser = new PaddingAttributeParser(parameter.getProperty("border", "1px"));
            this.borderLeft = new SizeValue(parser.getLeft());
            this.borderRight = new SizeValue(parser.getRight());
            this.borderTop = new SizeValue(parser.getTop());
            this.borderBottom = new SizeValue(parser.getBottom());
            parser = new PaddingAttributeParser(parameter.getProperty("color", "#ffff"));
            this.colorLeft = new Color(parser.getLeft());
            this.colorRight = new Color(parser.getRight());
            this.colorTop = new Color(parser.getTop());
            this.colorBottom = new Color(parser.getBottom());
            parser = new PaddingAttributeParser(parameter.getProperty("inset", "0px"));
            this.insetLeft = new SizeValue(parser.getLeft());
            this.insetRight = new SizeValue(parser.getRight());
            this.insetTop = new SizeValue(parser.getTop());
            this.insetBottom = new SizeValue(parser.getBottom());
        }
        catch (Exception e) {
            this.log.warning(e.getMessage());
        }
    }

    @Override
    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        r.saveState(null);
        int left = this.getBorder(element, this.borderLeft);
        int right = this.getBorder(element, this.borderRight);
        int top = this.getBorder(element, this.borderTop);
        int bottom = this.getBorder(element, this.borderBottom);
        int insetOffsetLeft = this.insetLeft.getValueAsInt(element.getWidth());
        int insetOffsetRight = this.insetRight.getValueAsInt(element.getWidth());
        int insetOffsetTop = this.insetTop.getValueAsInt(element.getHeight());
        int insetOffsetBottom = this.insetBottom.getValueAsInt(element.getHeight());
        if (left > 0) {
            this.setAlphaSaveColor(r, this.colorLeft);
            r.renderQuad(element.getX() - left + insetOffsetLeft, element.getY() - top + insetOffsetTop, left, element.getHeight() + top + bottom - insetOffsetTop - insetOffsetBottom);
        }
        if (right > 0) {
            this.setAlphaSaveColor(r, this.colorRight);
            r.renderQuad(element.getX() + element.getWidth() - insetOffsetRight, element.getY() - top + insetOffsetTop, right, element.getHeight() + top + bottom - insetOffsetTop - insetOffsetBottom);
        }
        if (top > 0) {
            this.setAlphaSaveColor(r, this.colorTop);
            r.renderQuad(element.getX() - left + insetOffsetLeft, element.getY() - top + insetOffsetTop, element.getWidth() + left + right - insetOffsetLeft - insetOffsetRight, top);
        }
        if (bottom > 0) {
            this.setAlphaSaveColor(r, this.colorBottom);
            r.renderQuad(element.getX() - left + insetOffsetLeft, element.getY() + element.getHeight() - insetOffsetBottom, element.getWidth() + left + right - insetOffsetLeft - insetOffsetRight, bottom);
        }
        r.restoreState();
    }

    private void setAlphaSaveColor(NiftyRenderEngine r, Color color) {
        if (r.isColorAlphaChanged()) {
            r.setColorIgnoreAlpha(color);
        } else {
            r.setColor(color);
        }
    }

    private int getBorder(Element element, SizeValue sizeValue) {
        int left = (int)sizeValue.getValue(element.getParent().getWidth());
        if (left == -1) {
            left = 0;
        }
        return left;
    }

    @Override
    public void deactivate() {
    }
}

