/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.gui;

import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.ClassfileScanner;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.dependency.LinkMaximizer;
import com.jeantessier.dependency.LinkMinimizer;
import com.jeantessier.dependencyfinder.gui.DependencyFinder;
import com.jeantessier.dependencyfinder.gui.JavaBytecodeFileFilter;
import com.jeantessier.dependencyfinder.gui.VerboseListener;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;

public class DependencyExtractAction
extends AbstractAction
implements Runnable {
    private DependencyFinder model;

    public DependencyExtractAction(DependencyFinder model) {
        this.model = model;
        this.putValue("LongDescription", "Extract dependencies from compiled classes");
        this.putValue("Name", "Extract");
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("icons/extract.gif")));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = this.model.getInputFiles().isEmpty() ? new JFileChooser(new File(".")) : new JFileChooser(this.model.getInputFiles().iterator().next());
        chooser.addChoosableFileFilter(new JavaBytecodeFileFilter());
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(true);
        int returnValue = chooser.showDialog(this.model, "Extract");
        if (returnValue == 0) {
            for (File file : chooser.getSelectedFiles()) {
                this.model.addInputFile(file);
            }
            new Thread(this).start();
        }
    }

    @Override
    public void run() {
        Date start = new Date();
        this.model.getStatusLine().showInfo("Scanning ...");
        ClassfileScanner scanner = new ClassfileScanner();
        scanner.load(this.model.getInputFiles());
        this.model.getProgressBar().setMaximum(scanner.getNbFiles());
        this.model.getMonitor().setClosedSession(false);
        TransientClassfileLoader loader = new TransientClassfileLoader(this.model.getClassfileLoaderDispatcher());
        ((ClassfileLoader)loader).addLoadListener(new VerboseListener(this.model.getStatusLine(), this.model.getProgressBar()));
        ((ClassfileLoader)loader).addLoadListener(this.model.getMonitor());
        loader.load(this.model.getInputFiles());
        if (this.model.getMaximize()) {
            this.model.getStatusLine().showInfo("Maximizing ...");
            new LinkMaximizer().traverseNodes(this.model.getPackages());
        } else if (this.model.getMinimize()) {
            this.model.getStatusLine().showInfo("Minimizing ...");
            new LinkMinimizer().traverseNodes(this.model.getPackages());
        }
        Date stop = new Date();
        this.model.getStatusLine().showInfo("Done (" + (double)(stop.getTime() - start.getTime()) / 1000.0 + " secs).");
        this.model.setTitle("Dependency Finder - Extractor");
    }
}

