/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.CollectionMeasurement;
import com.jeantessier.metrics.Measurement;
import com.jeantessier.metrics.MeasurementBase;
import com.jeantessier.metrics.MeasurementDescriptor;
import com.jeantessier.metrics.Metrics;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

public abstract class AccumulatorMeasurement
extends MeasurementBase
implements CollectionMeasurement {
    private Map<String, Collection<String>> terms = new HashMap<String, Collection<String>>();
    private Collection<String> values = new TreeSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccumulatorMeasurement(MeasurementDescriptor descriptor, Metrics context, String initText) {
        super(descriptor, context, initText);
        if (initText != null) {
            try {
                String line;
                BufferedReader in = new BufferedReader(new StringReader(initText));
                while ((line = in.readLine()) != null) {
                    Perl5Util perl5Util = AccumulatorMeasurement.perl();
                    synchronized (perl5Util) {
                        if (AccumulatorMeasurement.perl().match("/^\\s*(\\S+)\\s*(.*)/", line)) {
                            String name = AccumulatorMeasurement.perl().group(1);
                            String re = AccumulatorMeasurement.perl().group(2);
                            Collection<String> res = this.terms.get(name);
                            if (res == null) {
                                res = new ArrayList<String>();
                                this.terms.put(name, res);
                            }
                            if (re != null && re.length() > 0) {
                                res.add(re);
                            }
                        }
                    }
                }
                in.close();
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass()).debug((Object)("Cannot initialize with \"" + initText + "\""), (Throwable)ex);
                this.terms.clear();
            }
        }
        this.logTerms(initText);
    }

    private void logTerms(String initText) {
        Logger.getLogger(this.getClass()).debug((Object)("Initialize with\n" + initText));
        Logger.getLogger(this.getClass()).debug((Object)"Terms:");
        for (Map.Entry<String, Collection<String>> entry : this.terms.entrySet()) {
            Logger.getLogger(this.getClass()).debug((Object)("\t" + entry.getKey()));
            for (String s : entry.getValue()) {
                Logger.getLogger(this.getClass()).debug((Object)("\t\t" + s));
            }
        }
    }

    @Override
    public Number getValue() {
        return this.getValues().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getValues().isEmpty();
    }

    @Override
    protected double compute() {
        return this.getValues().size();
    }

    @Override
    public Collection<String> getValues() {
        if (!this.isCached()) {
            this.values.clear();
            this.populateValues();
            this.setCached(true);
        }
        return Collections.unmodifiableCollection(this.values);
    }

    protected abstract void populateValues();

    protected void filterMetrics(Metrics metrics) {
        for (Map.Entry<String, Collection<String>> entry : this.terms.entrySet()) {
            String name = entry.getKey();
            Collection<String> res = entry.getValue();
            Measurement measurement = metrics.getMeasurement(name);
            if (!(measurement instanceof CollectionMeasurement)) continue;
            this.filterMeasurement((CollectionMeasurement)measurement, res);
        }
    }

    private void filterMeasurement(CollectionMeasurement measurement, Collection<String> res) {
        if (res.isEmpty()) {
            this.values.addAll(measurement.getValues());
        } else {
            for (String member : measurement.getValues()) {
                this.filterElement(member, res);
            }
        }
    }

    private void filterElement(String element, Collection<String> res) {
        boolean found = false;
        Iterator<String> i = res.iterator();
        while (!found && i.hasNext()) {
            found = this.evaluateRE(i.next(), element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evaluateRE(String re, String element) {
        boolean result = false;
        Perl5Util perl5Util = AccumulatorMeasurement.perl();
        synchronized (perl5Util) {
            if (AccumulatorMeasurement.perl().match(re, element)) {
                result = true;
                if (AccumulatorMeasurement.perl().group(1) != null) {
                    this.values.add(AccumulatorMeasurement.perl().group(1));
                } else {
                    this.values.add(element);
                }
            }
        }
        return result;
    }
}

