/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.Measurement;
import com.jeantessier.metrics.MeasurementBase;
import com.jeantessier.metrics.MeasurementDescriptor;
import com.jeantessier.metrics.MeasurementVisitor;
import com.jeantessier.metrics.Metrics;
import com.jeantessier.metrics.StatisticalMeasurement;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

public class SumMeasurement
extends MeasurementBase {
    private List<String> terms = new LinkedList<String>();
    private double value = 0.0;

    public SumMeasurement(MeasurementDescriptor descriptor, Metrics context, String initText) {
        super(descriptor, context, initText);
        try {
            String line;
            BufferedReader in = new BufferedReader(new StringReader(initText));
            while ((line = in.readLine()) != null) {
                this.terms.add(line.trim());
            }
            in.close();
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass()).debug((Object)("Cannot initialize with \"" + initText + "\""), (Throwable)ex);
            this.terms.clear();
        }
    }

    public List<String> getTerms() {
        return this.terms;
    }

    @Override
    public boolean isEmpty() {
        this.compute();
        return super.isEmpty();
    }

    @Override
    public void accept(MeasurementVisitor visitor) {
        visitor.visitSumMeasurement(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected double compute() {
        if (!this.isCached()) {
            SumMeasurement sumMeasurement = this;
            synchronized (sumMeasurement) {
                if (!this.isCached()) {
                    this.value = 0.0;
                    this.setEmpty(true);
                    if (this.getContext() != null) {
                        Logger.getLogger(this.getClass()).debug((Object)("Start computing \"" + this.getShortName() + "\" on \"" + this.getContext().getName() + "\": value=" + this.value));
                    } else {
                        Logger.getLogger(this.getClass()).debug((Object)("Start computing \"" + this.getShortName() + "\" on null: value=" + this.value));
                    }
                    for (String term : this.getTerms()) {
                        Logger.getLogger(this.getClass()).debug((Object)("Evaluating term \"" + term + "\""));
                        double termValue = Double.NaN;
                        try {
                            termValue = Double.parseDouble(term);
                        }
                        catch (NumberFormatException ex) {
                            termValue = term.startsWith("-") ? -1.0 * this.evaluateMeasurement(term.substring(1)) : this.evaluateMeasurement(term);
                        }
                        Logger.getLogger(this.getClass()).debug((Object)("term \"" + term + "\" is " + termValue));
                        this.value += termValue;
                        Logger.getLogger(this.getClass()).debug((Object)("value=" + this.value));
                    }
                    if (this.getContext() != null) {
                        Logger.getLogger(this.getClass()).debug((Object)("Stop computing \"" + this.getShortName() + "\" on \"" + this.getContext().getName() + "\": value=" + this.value));
                    } else {
                        Logger.getLogger(this.getClass()).debug((Object)("Stop computing \"" + this.getShortName() + "\" on null: value=" + this.value));
                    }
                    this.setCached(true);
                }
            }
        }
        if (this.getContext() != null) {
            Logger.getLogger(this.getClass()).debug((Object)("\"" + this.getShortName() + "\" on \"" + this.getContext().getName() + "\": value=" + this.value));
        } else {
            Logger.getLogger(this.getClass()).debug((Object)("\"" + this.getShortName() + "\" on null: value=" + this.value));
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double evaluateMeasurement(String name) {
        double result = 0.0;
        if (name.length() != 0) {
            int dispose;
            Perl5Util perl5Util = SumMeasurement.perl();
            synchronized (perl5Util) {
                if (SumMeasurement.perl().match("/(.*)\\s+(dispose_\\w+)$/i", name)) {
                    name = SumMeasurement.perl().group(1);
                    String disposeText = SumMeasurement.perl().group(2);
                    dispose = disposeText.equalsIgnoreCase("DISPOSE_IGNORE") ? 0 : (disposeText.equalsIgnoreCase("DISPOSE_MINIMUM") ? 1 : (disposeText.equalsIgnoreCase("DISPOSE_MEDIAN") ? 2 : (disposeText.equalsIgnoreCase("DISPOSE_AVERAGE") ? 3 : (disposeText.equalsIgnoreCase("DISPOSE_STANDARD_DEVIATION") ? 4 : (disposeText.equalsIgnoreCase("DISPOSE_MAXIMUM") ? 5 : (disposeText.equalsIgnoreCase("DISPOSE_SUM") ? 6 : (disposeText.equalsIgnoreCase("DISPOSE_NB_DATA_POINTS") ? 7 : 0)))))));
                } else {
                    dispose = 0;
                }
            }
            Measurement measurement = this.getContext().getMeasurement(name);
            if (measurement instanceof StatisticalMeasurement) {
                StatisticalMeasurement stats = (StatisticalMeasurement)measurement;
                switch (dispose) {
                    case 1: {
                        result = stats.getMinimum();
                        break;
                    }
                    case 2: {
                        result = stats.getMedian();
                        break;
                    }
                    case 3: {
                        result = stats.getAverage();
                        break;
                    }
                    case 4: {
                        result = stats.getStandardDeviation();
                        break;
                    }
                    case 5: {
                        result = stats.getMaximum();
                        break;
                    }
                    case 6: {
                        result = stats.getSum();
                        break;
                    }
                    case 7: {
                        result = stats.getNbDataPoints();
                        break;
                    }
                    default: {
                        result = stats.getValue().doubleValue();
                        break;
                    }
                }
            } else {
                result = measurement.getValue().doubleValue();
            }
            if (super.isEmpty()) {
                this.setEmpty(measurement.isEmpty());
            }
        }
        return result;
    }
}

