/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
extends Spatial
implements Savable {
    private static final Logger logger = Logger.getLogger(Node.class.getName());
    protected SafeArrayList<Spatial> children = new SafeArrayList<Spatial>(Spatial.class);

    public Node() {
    }

    public Node(String name) {
        super(name);
    }

    public int getQuantity() {
        return this.children.size();
    }

    @Override
    protected void setTransformRefresh() {
        super.setTransformRefresh();
        for (Spatial child : this.children.getArray()) {
            if ((child.refreshFlags & 1) != 0) continue;
            child.setTransformRefresh();
        }
    }

    @Override
    protected void setLightListRefresh() {
        super.setLightListRefresh();
        for (Spatial child : this.children.getArray()) {
            if ((child.refreshFlags & 4) != 0) continue;
            child.setLightListRefresh();
        }
    }

    @Override
    protected void updateWorldBound() {
        super.updateWorldBound();
        BoundingVolume resultBound = null;
        for (Spatial child : this.children.getArray()) {
            assert ((child.refreshFlags & 2) == 0);
            if (resultBound != null) {
                resultBound.mergeLocal(child.getWorldBound());
                continue;
            }
            if (child.getWorldBound() == null) continue;
            resultBound = child.getWorldBound().clone(this.worldBound);
        }
        this.worldBound = resultBound;
    }

    @Override
    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.children.isEmpty()) {
            return;
        }
        for (Spatial child : this.children.getArray()) {
            child.updateLogicalState(tpf);
        }
    }

    @Override
    public void updateGeometricState() {
        if ((this.refreshFlags & 4) != 0) {
            this.updateWorldLightList();
        }
        if ((this.refreshFlags & 1) != 0) {
            this.updateWorldTransforms();
        }
        if (!this.children.isEmpty()) {
            for (Spatial child : this.children.getArray()) {
                child.updateGeometricState();
            }
        }
        if ((this.refreshFlags & 2) != 0) {
            this.updateWorldBound();
        }
        assert (this.refreshFlags == 0);
    }

    @Override
    public int getTriangleCount() {
        int count = 0;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                count += this.children.get(i).getTriangleCount();
            }
        }
        return count;
    }

    @Override
    public int getVertexCount() {
        int count = 0;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                count += this.children.get(i).getVertexCount();
            }
        }
        return count;
    }

    public int attachChild(Spatial child) {
        if (child == null) {
            throw new NullPointerException();
        }
        if (child.getParent() != this && child != this) {
            if (child.getParent() != null) {
                child.getParent().detachChild(child);
            }
            child.setParent(this);
            this.children.add(child);
            child.setTransformRefresh();
            child.setLightListRefresh();
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Child ({0}) attached to this node ({1})", new Object[]{child.getName(), this.getName()});
            }
        }
        return this.children.size();
    }

    public int attachChildAt(Spatial child, int index) {
        if (child == null) {
            throw new NullPointerException();
        }
        if (child.getParent() != this && child != this) {
            if (child.getParent() != null) {
                child.getParent().detachChild(child);
            }
            child.setParent(this);
            this.children.add(index, child);
            child.setTransformRefresh();
            child.setLightListRefresh();
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Child ({0}) attached to this node ({1})", new Object[]{child.getName(), this.getName()});
            }
        }
        return this.children.size();
    }

    public int detachChild(Spatial child) {
        if (child == null) {
            throw new NullPointerException();
        }
        if (child.getParent() == this) {
            int index = this.children.indexOf(child);
            if (index != -1) {
                this.detachChildAt(index);
            }
            return index;
        }
        return -1;
    }

    public int detachChildNamed(String childName) {
        if (childName == null) {
            throw new NullPointerException();
        }
        int max = this.children.size();
        for (int x = 0; x < max; ++x) {
            Spatial child = this.children.get(x);
            if (!childName.equals(child.getName())) continue;
            this.detachChildAt(x);
            return x;
        }
        return -1;
    }

    public Spatial detachChildAt(int index) {
        Spatial child = this.children.remove(index);
        if (child != null) {
            child.setParent(null);
            logger.log(Level.INFO, "{0}: Child removed.", this.toString());
            this.setBoundRefresh();
            child.setTransformRefresh();
            child.setLightListRefresh();
        }
        return child;
    }

    public void detachAllChildren() {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            this.detachChildAt(i);
        }
        logger.log(Level.INFO, "{0}: All children removed.", this.toString());
    }

    public int getChildIndex(Spatial sp) {
        return this.children.indexOf(sp);
    }

    public void swapChildren(int index1, int index2) {
        Spatial c2 = this.children.get(index2);
        Spatial c1 = this.children.remove(index1);
        this.children.add(index1, c2);
        this.children.remove(index2);
        this.children.add(index2, c1);
    }

    public Spatial getChild(int i) {
        return this.children.get(i);
    }

    public Spatial getChild(String name) {
        if (name == null) {
            return null;
        }
        for (Spatial child : this.children.getArray()) {
            Spatial out;
            if (name.equals(child.getName())) {
                return child;
            }
            if (!(child instanceof Node) || (out = ((Node)child).getChild(name)) == null) continue;
            return out;
        }
        return null;
    }

    public boolean hasChild(Spatial spat) {
        if (this.children.contains(spat)) {
            return true;
        }
        for (Spatial child : this.children.getArray()) {
            if (!(child instanceof Node) || !((Node)child).hasChild(spat)) continue;
            return true;
        }
        return false;
    }

    public List<Spatial> getChildren() {
        return this.children;
    }

    @Override
    public void setMaterial(Material mat) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).setMaterial(mat);
        }
    }

    @Override
    public void setLodLevel(int lod) {
        super.setLodLevel(lod);
        for (Spatial child : this.children.getArray()) {
            child.setLodLevel(lod);
        }
    }

    @Override
    public int collideWith(Collidable other, CollisionResults results) {
        int total = 0;
        for (Spatial child : this.children.getArray()) {
            total += child.collideWith(other, results);
        }
        return total;
    }

    public <T extends Spatial> List<T> descendantMatches(Class<T> spatialSubclass, String nameRegex) {
        ArrayList<Spatial> newList = new ArrayList<Spatial>();
        if (this.getQuantity() < 1) {
            return newList;
        }
        for (Spatial child : this.getChildren()) {
            if (child.matches(spatialSubclass, nameRegex)) {
                newList.add(child);
            }
            if (!(child instanceof Node)) continue;
            newList.addAll(((Node)child).descendantMatches(spatialSubclass, nameRegex));
        }
        return newList;
    }

    public <T extends Spatial> List<T> descendantMatches(Class<T> spatialSubclass) {
        return this.descendantMatches(spatialSubclass, null);
    }

    public <T extends Spatial> List<T> descendantMatches(String nameRegex) {
        return this.descendantMatches(null, nameRegex);
    }

    @Override
    public Node clone(boolean cloneMaterials) {
        Node nodeClone = (Node)super.clone(cloneMaterials);
        return nodeClone;
    }

    @Override
    public Spatial deepClone() {
        Node nodeClone = (Node)super.clone();
        nodeClone.children = new SafeArrayList<Spatial>(Spatial.class);
        for (Spatial child : this.children) {
            Spatial childClone = child.deepClone();
            childClone.parent = nodeClone;
            nodeClone.children.add(childClone);
        }
        return nodeClone;
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        e.getCapsule(this).writeSavableArrayList(new ArrayList<Spatial>(this.children), "children", null);
    }

    @Override
    public void read(JmeImporter e) throws IOException {
        this.children = new SafeArrayList<Spatial>(Spatial.class, e.getCapsule(this).readSavableArrayList("children", null));
        if (this.children != null) {
            for (Spatial child : this.children.getArray()) {
                child.parent = this;
            }
        }
        super.read(e);
    }

    @Override
    public void setModelBound(BoundingVolume modelBound) {
        if (this.children != null) {
            for (Spatial child : this.children.getArray()) {
                child.setModelBound(modelBound != null ? modelBound.clone(null) : null);
            }
        }
    }

    @Override
    public void updateModelBound() {
        if (this.children != null) {
            for (Spatial child : this.children.getArray()) {
                child.updateModelBound();
            }
        }
    }

    @Override
    public void depthFirstTraversal(SceneGraphVisitor visitor) {
        for (Spatial child : this.children.getArray()) {
            child.depthFirstTraversal(visitor);
        }
        visitor.visit(this);
    }

    @Override
    protected void breadthFirstTraversal(SceneGraphVisitor visitor, Queue<Spatial> queue) {
        queue.addAll(this.children);
    }
}

