/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLException;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class Animator {
    private volatile ArrayList drawables = new ArrayList();
    private Runnable runnable;
    private Thread thread;
    private volatile boolean shouldStop;
    protected boolean ignoreExceptions;
    protected boolean printExceptions;
    private boolean runAsFastAsPossible;
    private List lightweights = new ArrayList();
    private Map repaintManagers = new IdentityHashMap();
    private Map dirtyRegions = new IdentityHashMap();
    private Runnable drawWithRepaintManagerRunnable = new Runnable(){

        public void run() {
            Object object;
            Object object2;
            JComponent jComponent;
            Iterator<Object> iterator = Animator.this.lightweights.iterator();
            while (iterator.hasNext()) {
                jComponent = (JComponent)iterator.next();
                object2 = RepaintManager.currentManager(jComponent);
                ((RepaintManager)object2).markCompletelyDirty(jComponent);
                Animator.this.repaintManagers.put(object2, object2);
                object = jComponent.getVisibleRect();
                int n = ((Rectangle)object).x;
                int n2 = ((Rectangle)object).y;
                while (jComponent != null) {
                    n += jComponent.getX();
                    n2 += jComponent.getY();
                    Container container = jComponent.getParent();
                    if (container == null || !(container instanceof JComponent)) {
                        jComponent = null;
                        continue;
                    }
                    jComponent = (JComponent)container;
                    if (jComponent.isOptimizedDrawingEnabled()) continue;
                    object2 = RepaintManager.currentManager(jComponent);
                    Animator.this.repaintManagers.put(object2, object2);
                    Rectangle rectangle = (Rectangle)Animator.this.dirtyRegions.get(jComponent);
                    if (rectangle == null) {
                        rectangle = new Rectangle(n, n2, ((Rectangle)object).width, ((Rectangle)object).height);
                        Animator.this.dirtyRegions.put(jComponent, rectangle);
                        continue;
                    }
                    rectangle.add(new Rectangle(n, n2, ((Rectangle)object).width, ((Rectangle)object).height));
                }
            }
            iterator = Animator.this.dirtyRegions.keySet().iterator();
            while (iterator.hasNext()) {
                jComponent = (JComponent)iterator.next();
                object2 = (Rectangle)Animator.this.dirtyRegions.get(jComponent);
                object = RepaintManager.currentManager(jComponent);
                ((RepaintManager)object).addDirtyRegion(jComponent, ((Rectangle)object2).x, ((Rectangle)object2).y, ((Rectangle)object2).width, ((Rectangle)object2).height);
            }
            iterator = Animator.this.repaintManagers.keySet().iterator();
            while (iterator.hasNext()) {
                ((RepaintManager)iterator.next()).paintDirtyRegions();
            }
            Animator.this.dirtyRegions.clear();
            Animator.this.repaintManagers.clear();
        }
    };

    public Animator() {
    }

    public Animator(GLAutoDrawable gLAutoDrawable) {
        this.add(gLAutoDrawable);
    }

    public synchronized void add(GLAutoDrawable gLAutoDrawable) {
        ArrayList arrayList = (ArrayList)this.drawables.clone();
        arrayList.add(gLAutoDrawable);
        this.drawables = arrayList;
        this.notifyAll();
    }

    public synchronized void remove(GLAutoDrawable gLAutoDrawable) {
        ArrayList arrayList = (ArrayList)this.drawables.clone();
        arrayList.remove(gLAutoDrawable);
        this.drawables = arrayList;
    }

    public Iterator drawableIterator() {
        return this.drawables.iterator();
    }

    public void setIgnoreExceptions(boolean bl) {
        this.ignoreExceptions = bl;
    }

    public void setPrintExceptions(boolean bl) {
        this.printExceptions = bl;
    }

    public final void setRunAsFastAsPossible(boolean bl) {
        this.runAsFastAsPossible = bl;
    }

    protected void display() {
        Iterator iterator = this.drawableIterator();
        while (iterator.hasNext()) {
            GLAutoDrawable gLAutoDrawable = (GLAutoDrawable)iterator.next();
            if (gLAutoDrawable instanceof JComponent) {
                this.lightweights.add(gLAutoDrawable);
                continue;
            }
            try {
                gLAutoDrawable.display();
            }
            catch (RuntimeException runtimeException) {
                if (this.ignoreExceptions) {
                    if (!this.printExceptions) continue;
                    runtimeException.printStackTrace();
                    continue;
                }
                throw runtimeException;
            }
        }
        if (this.lightweights.size() > 0) {
            try {
                SwingUtilities.invokeAndWait(this.drawWithRepaintManagerRunnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.lightweights.clear();
        }
    }

    public synchronized void start() {
        if (this.thread != null) {
            throw new GLException("Already started");
        }
        if (this.runnable == null) {
            this.runnable = new MainLoop();
        }
        this.thread = new Thread(this.runnable);
        this.thread.start();
    }

    public synchronized boolean isAnimating() {
        return this.thread != null;
    }

    public synchronized void stop() {
        this.shouldStop = true;
        this.notifyAll();
        if (Thread.currentThread() == this.thread || EventQueue.isDispatchThread()) {
            return;
        }
        while (this.shouldStop && this.thread != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    class MainLoop
    implements Runnable {
        MainLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!Animator.this.shouldStop) {
                    if (Animator.this.drawables.size() == 0) {
                        Animator animator = Animator.this;
                        synchronized (animator) {
                            while (Animator.this.drawables.size() == 0 && !Animator.this.shouldStop) {
                                try {
                                    Animator.this.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                    }
                    Animator.this.display();
                    if (Animator.this.runAsFastAsPossible) continue;
                    Thread.yield();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                Animator.this.shouldStop = false;
                Animator animator = Animator.this;
                synchronized (animator) {
                    Animator.this.thread = null;
                    Animator.this.notify();
                }
                throw throwable;
            }
            Animator.this.shouldStop = false;
            Animator animator = Animator.this;
            synchronized (animator) {
                Animator.this.thread = null;
                Animator.this.notify();
            }
        }
    }
}

