/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements;

import de.lessvoid.nifty.elements.Action;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.screen.Screen;

public class ElementMoveAction
implements Action {
    private Element destinationElement;

    public ElementMoveAction(Element destinationElement) {
        this.destinationElement = destinationElement;
    }

    @Override
    public void perform(Screen screen, Element element) {
        Element parent = element.getParent();
        if (parent != null) {
            parent.internalRemoveElement(element);
        }
        element.setParent(this.destinationElement);
        this.destinationElement.add(element);
        this.addToFocusHandler(element);
        screen.layoutLayers();
    }

    private void addToFocusHandler(Element element) {
        if (element.isFocusable()) {
            element.getFocusHandler().addElement(element);
        }
        for (int i = 0; i < element.getElements().size(); ++i) {
            this.addToFocusHandler(element.getElements().get(i));
        }
    }
}

