/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements.render;

import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.ElementRenderer;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.Color;
import java.util.Random;

public class PanelRenderer
implements ElementRenderer {
    private Color backgroundColor;
    private Color debugColor;

    @Override
    public void render(Element element, NiftyRenderEngine r) {
        if (element.getNifty().isDebugOptionPanelColors()) {
            r.saveState(null);
            r.setColor(this.getDebugColor());
            r.renderQuad(element.getX(), element.getY(), element.getWidth(), element.getHeight());
            r.restoreState();
            return;
        }
        if (this.backgroundColor != null) {
            r.saveState(null);
            if (!r.isColorChanged()) {
                if (r.isColorAlphaChanged()) {
                    r.setColorIgnoreAlpha(this.backgroundColor);
                } else {
                    r.setColor(this.backgroundColor);
                }
            }
            r.renderQuad(element.getX(), element.getY(), element.getWidth(), element.getHeight());
            r.restoreState();
        }
    }

    private Color getDebugColor() {
        if (this.debugColor != null) {
            return this.debugColor;
        }
        this.debugColor = new Color(new Random().nextFloat(), new Random().nextFloat(), new Random().nextFloat(), 0.5f);
        return this.debugColor;
    }

    public void setBackgroundColor(Color newBackgroundColor) {
        this.backgroundColor = newBackgroundColor;
    }
}

